
var fs = require('fs');
var crypt = require('crypto'); // webkit already uses a variable named 'crypto'
var http = require('http');
var os = require('os');
var mkdirp = require('mkdirp');
var getDirName = require('path').dirname;


var exec = require('child_process').exec;
// var gui = require('nw.gui');
var { shell } = require('electron')
const path = require('path')
const serverPath = 'http://armorcritical.com/armorcritical-electron/'
const rootPathOld = require('electron-root-path').rootPath;
const rootPath = path.join(os.homedir(), '.armorcritical/');
// import { protocol } from "electron";
//var app = require('electron');


console.log('server path: ' + serverPath);
console.log('local path:' + rootPathOld);
console.log('home path: '+ rootPath);

// app.protocol.registerFileProtocol('file', (request, callback) => {
//     const pathname = decodeURI(request.url.replace('file:///', ''));
//     callback(pathname);
// });


fs.writeFile(path.join(rootPath, 'logs/error.log'), 'Armor Critical!\r\n', { encoding:'utf8'}, function(){});
var errlog = function(str)
{
    var message = '[' + (new Date()).toISOString() + '] ' +  str + '\r\n';
    console.log(message);
    fs.appendFile(path.join(rootPath, 'logs/error.log'), message, { encoding:'utf8'}, function(){});
};

process.on('uncaughtException', function(error)
{
    errlog(error.stack);
    process.exit(1);
});

var CHAT = {
    webserver: { host:"http://armorcritical.com" },
    chatserver: { host:"armorcritical.com", port:8400 },
    remotepath: "armorcritical-electron/",
    hashurl: "http://armorcritical.com/api/getfilehashes/?electron",
    os: "win",
    activemodal: null,
    starttime : (new Date()).getTime(),
    pagetitle : "ARMOR CRITICAL - Chat",
    socket : {},
    connected : false,
    reconnectattempts : 10,
    reconnectTimer : 0,
    reconnectDelay : 10, // in seconds
    updategamesTimer : 0,
    chatInputTimer : 0,
    keepaliveTimer : 0,
    AFKTimer : 0, // increments as long as mouse isn't being moved or text being typed
    setToAFK : false, // true only if user sets himself to afk
    isAFK : false,
    afkdelay : 0,
    ROOMS : {},
    GAMES : {},
    USERS : {},
    activeRoom : "lobby",
    joining : true,
    inputlines : [],
    inputlinescursor : -1,
    lastPMsender : "",
    selectedName : "",
    lastGameUpdateTime : 0,
    activeGame : -1,
    SOUNDS : {},
    isSoundEnabled : false,
    timeout : null,
    launcher : null,
    launcherstatus : "ready",
    launcherstatusdiv : null,
    gamepasswordinput : "none",
    joininggame : null,
    time : (new Date()).getTime()
};
var request = null;

// Load user.json file
var USER = {};


var checkLocalCopyOrDownload = function(localPath, sourcePath, callback) {
    if(!fs.existsSync(localPath)) {
        mkdirp(getDirName(localPath), function (err) {
            if (err) return callback(err);
            downloadAsset(sourcePath, localPath, callback);
        });
    } else {
        callback();
    }
}

var downloadAsset = function(url, dest, cb) {
    var file = fs.createWriteStream(dest);
    var request = http.get(url, function(response) {
      response.pipe(file);
      file.on('finish', function() {
        file.close(cb);  // close() is async, call cb after close completes.
      });
    }).on('error', function(err) { // Handle errors
      fs.unlink(dest); // Delete the file async. (But we don't check the result)
      if (cb) cb(err.message);
    });
  };

var loadAssets = function(callback) {
    checkLocalCopyOrDownload(path.join(rootPath, 'config/user.json'), path.join(serverPath, 'config/user.json.default'), () => {
        checkLocalCopyOrDownload(path.join(rootPath, 'sounds/blip.ogg'), path.join(serverPath, 'sounds/blip.ogg'), () => {
            checkLocalCopyOrDownload(path.join(rootPath, 'sounds/blip.mp3'), path.join(serverPath, 'sounds/blip.mp3'), () => {
                checkLocalCopyOrDownload(path.join(rootPath, 'sounds/bugle.ogg'), path.join(serverPath, 'sounds/bugle.ogg'), () => {
                    checkLocalCopyOrDownload(path.join(rootPath, 'sounds/bugle.mp3'), path.join(serverPath, 'sounds/bugle.mp3'), callback);
                });
            });
        });
    });    
}

var loadUserSettings = function() {
    try {
        USER = JSON.parse(fs.readFileSync(path.join(rootPath, 'config/user.json'), 'utf8'));
    } catch(e) {
        console.log("Error loading user settings", e);
    }
    if (typeof USER.sitekey == 'undefined') USER.sitekey = "";
    if (typeof USER.permissions == 'undefined') USER.permissions = "";
}





CHAT.showModal = function(selector)
{
    $("#modalbg").show();
    if (CHAT.activemodal !== null) CHAT.activemodal.hide();
    CHAT.activemodal = $(selector);
    CHAT.activemodal.show();
    CHAT.positionModal();
};

CHAT.positionModal = function()
{
    CHAT.activemodal.css("top", ((window.innerHeight / 2) - (CHAT.activemodal.height() / 2)) * 0.9);
    CHAT.activemodal.css("left", (window.innerWidth / 2) - (CHAT.activemodal.width() / 2));
};

CHAT.hideModal = function(event, force)
{
    if (typeof force == 'undefined') force = false;
    if (CHAT.activemodal !== null)
    {
        if (CHAT.activemodal.selector == "#loginmodal" && force === false) return;
        CHAT.activemodal.hide();
        CHAT.activemodal = null;
    }
    $("#modalbg").hide();
};

CHAT.loop = function()
{
    CHAT.time = (new Date()).getTime();
    if (CHAT.connected)
    {
        if (!CHAT.setToAFK && !CHAT.isAFK && CHAT.time > CHAT.AFKTimer && !CHAT.USERS[USER.username].ingame)
        {
            CHAT.isAFK = true;
            var request = {};
            request.action = "setafk";
            request.content = true;
            CHAT.send(request);
        }
        if (CHAT.time > CHAT.keepaliveTimer)
        {
            $.get(CHAT.webserver.host + "/keepalive");
            CHAT.keepaliveTimer = CHAT.time + (28 * 60 * 1000); // 28 minutes
        }
    } else if (CHAT.activemodal == null && CHAT.reconnectattempts == 0)
    {
        CHAT.showModal("#loginmodal");
    }
};

CHAT.connect = function()
{
    CHAT.socket = io.connect("http://" + CHAT.chatserver.host + ":" + CHAT.chatserver.port + "/",
    {
        'force new connection': true,
        'forceNew': true,
        'reconnection delay': CHAT.reconnectDelay * 1000,
        'max reconnection attempts': CHAT.reconnectattempts
    });
    CHAT.socket.on('connect', CHAT.onOpen);
    CHAT.socket.on('disconnect', CHAT.onClose);
    CHAT.socket.on('message', CHAT.onMessage);
    CHAT.socket.on('error', CHAT.onError);
};

CHAT.onOpen = function()
{
    console.log("Open");
    CHAT.GAMES = {};
    CHAT.updateGamesList();
    $("div#gameinfo").html("");

    var message = {};
    message.action = "connect";
    message.userkey = USER.userkey;
    CHAT.send(message);
};

CHAT.onClose = function()
{
    console.log("Close");
    CHAT.connected = false;

    CHAT.GAMES = {};
    CHAT.updateGamesList();
    $("div#gameinfo").html("");

    var ts = Math.round(CHAT.time / 1000);
    if (CHAT.reconnectattempts > 0)
    {
        CHAT.addMessage("", "Notice", "Disconnected!  Attempting to reconnect...", ts);
        CHAT.reconnectTimer = (ts * 1000) + (CHAT.reconnectDelay * 1000);
    } else CHAT.addMessage("", "Notice", "Disconnected!", ts);
};

CHAT.onMessage = function(message)
{
    var userindex = null;
    var r = null;
    if (message.action != 'updategames') console.log(message.action + "\t\t" + JSON.stringify(message));
    switch (message.action)
    {
        case "connected":
            console.log("Connected!");
            CHAT.connected = true;
            CHAT.switchToRoom("lobby");
            CHAT.addMessage("", "Notice", "Connected!", message.stamp);
            if (CHAT.activemodal !== null && CHAT.activemodal.selector == "#loginmodal") CHAT.hideModal(null, true);
            CHAT.saveUserFile();
            if (CHAT.isAFK)
            {
                var request = {};
                request.action = "setafk";
                request.content = true;
                CHAT.send(request);
            }
            $.post(CHAT.webserver.host + "/account/phpsignin", {username: USER.username, sitekey: USER.sitekey});
            CHAT.keepaliveTimer = CHAT.time + (28 * 60 * 1000); // 28 minutes
            if (CHAT.hasPermission('op') || CHAT.hasPermission('admin') || CHAT.hasPermission('guide') || CHAT.hasPermission('dev')) $("#adminmenu").show(); else $("#adminmenu").hide();
            if (CHAT.hasPermission('mute'))
            {
                $(document).on('dblclick', '.Normal > .timestamp', function()
                {
                    var parent = $(this).parent();
                    var source = parent.attr("source");
                    var stamp = parent.attr("stamp");
                    var val = $("input#chatinput").val();
                    if (val.split(" ")[0] == "/erase") $("input#chatinput").val(val + " " + stamp);
                    else $("input#chatinput").val("/erase " + source + " " + stamp);
                });
            } else $(document).off('dblclick', '.Normal > .timestamp');
            break;
        case "joinroom":
            if (typeof CHAT.ROOMS[message.room.name] == "undefined")
            {
                for (var u in message.room.users)
                {
                    CHAT.USERS[message.room.users[u].username] = message.room.users[u];
                    CHAT.USERS[message.room.users[u].username].ingame = false;
                }
                CHAT.ROOMS[message.room.name] = message.room;
                CHAT.ROOMS[message.room.name].topic = message.room.topic;
                $("div#chatroomtabs li:last").after("<li room='"+message.room.name+"'>"+message.room.name+"</li>");
                $("div.chatroom:last").after("<div class='chatroom scroll' room='"+message.room.name+"'></div>");
                $("div.chatroom:last").scroll(function()
                {
                    var scrollpos = $(this).scrollTop() - ($(this).prop('scrollHeight') - $(this).innerHeight());
                    if (scrollpos >- 30) $(this).addClass("scroll");
                    else $(this).removeClass("scroll");
                });
                $("div.playerlist:last").after("<div class='playerlist' room='"+message.room.name+"'></div>");
                CHAT.updatePlayerList(message.room.name);
                CHAT.switchToRoom(message.room.name);
            }
            break;
        case "userjoinedroom":
            userindex = CHAT.findUserInRoom(message.room, message.user.username);
            if (userindex == -1) // user not found in list
            {
                CHAT.USERS[message.user.username] = message.user;
                CHAT.USERS[message.user.username].ingame = false;
                CHAT.ROOMS[message.room].users.push(message.user); // add user to list
                CHAT.addMessage(message.room, "Event", message.user.username + " has joined the room.", message.stamp);
                CHAT.updatePlayerList(message.room);
            }
            break;
        case "leaveroom":
            delete CHAT.ROOMS[message.room];
            $("div#chatroomtabs li[room='"+message.room+"']").remove();
            $("div.chatroom[room='"+message.room+"']").remove();
            $("div.playerlist[room='"+message.room+"']").remove();
            CHAT.switchToRoom("lobby");
            break;
        case "userleftroom":
            userindex = CHAT.findUserInRoom(message.room, message.username);
            if (userindex != -1) // user found in list
            {
                if (message.room == "lobby") delete CHAT.USERS[message.username]; // only way to leave lobby room is to quit; delete this user
                CHAT.ROOMS[message.room].users.splice(userindex,1);
                CHAT.addMessage(message.room, "Event", message.username + " has left the room.", message.stamp);
                CHAT.updatePlayerList(message.room);
            }
            break;
        case "userafk":
            CHAT.USERS[message.username].afk = message.afk;
            if (message.username == USER.username)
            {
                CHAT.isAFK = message.afk;
                if (!CHAT.isAFK) CHAT.setAFK = false;
            }
            for (r in CHAT.ROOMS) CHAT.updatePlayerList(r);
            break;
        case "message":
            CHAT.addMessage(message.room, message.type, message.content, message.stamp, message.source);
            break;
        case "control":
            switch (message.type)
            {
                case "Banned":
                    alert(message.content);
                    CHAT.reconnectattempts = 0;
                    CHAT.socket.disconnect();
                    CHAT.connected = false;
                    CHAT.addMessage("", "Notice", message.content, message.stamp);
                    break;
            }
            break;
        case "erase":
            if (typeof message.targetsource != "undefined" && typeof message.targetstamps != "undefined")
            {
                if (message.targetstamps.length > 0)
                {
                    for (var s in message.targetstamps)
                    {
                        $(".chatroom > div[stamp='" + message.targetstamps[s] + "'][source='" + message.targetsource + "']").hide();
                    }
                } else $(".chatroom > div[source='" + message.targetsource + "']").hide();
            }
            break;
        case "updategame":
            delete message.action;
            CHAT.GAMES[message.LaunchID] = message;
            if (message.LaunchID == CHAT.activeGame) CHAT.updateGameInfoFrame(message.LaunchID);
            CHAT.updateGamesList();
            break;
        case "deletegame":
            delete CHAT.GAMES[message.LaunchID];
            CHAT.updateGamesList();
            break;
        case "deleteallgames":
            CHAT.GAMES = {};
            CHAT.updateGamesList();
            break;
        case "inputline":
            $("input#chatinput").val(message.content);
            break;
        case "iconupdate":
            CHAT.USERS[message.username].icons = message.icons;
            for (r in CHAT.ROOMS) CHAT.updatePlayerList(r);
            break;
        case "topicupdate":
            CHAT.updateRoomTopic(message.room, message.content, message.source);
            break;
        default:
            console.log("Unknown message action: " + message.action);
    }
};

CHAT.onError = function()
{
    console.dir("Error: ", event.data);
};

CHAT.send = function(message)
{
    var jsonData = JSON.stringify(message);
    CHAT.socket.send(jsonData);
};

CHAT.addMessage = function(room, type, content, stamp, source)
{
    if (!source) source = "";
    var lstamp = CHAT.toLocalTime(stamp);
    var types = type.split(" ");
    switch(types[0])
    {
        case "Normal":
            if (source == USER.username)
            {
                CHAT.setAFK = false;
                CHAT.isAFK = false;
            }
            if (source == USER.username && content[0] != "`") type += " Me";
            if (content.indexOf("<a href") == -1)
            {
                content = content.replace(USER.username, "<span class='highlight'>"+USER.username+"</span>");
                content = content.replace(USER.username.toLowerCase(), "<span class='highlight'>"+USER.username.toLowerCase()+"</span>");
            }
            if (source == CHAT.selectedName) var spanclass = "user selected"; else var spanclass = "user";
            $("div.chatroom[room='"+room+"']").append("<div class='"+type+"' stamp='"+stamp+"' source='"+source.toLowerCase()+"'><span class='timestamp'>["+lstamp+"]</span> <span class='"+spanclass+"' user='"+source+"'>"+source+"</span> : "+content+"</div>\n");
            CHAT.removeOldMessages(room);
            CHAT.scrollToBottom();
            if (room != CHAT.activeRoom) $("div#chatroomtabs li[room='"+room+"']").html(room + " <img src='" + CHAT.webserver.host + "/images/icons/bullet_white.png' />");
            if (!CHAT.windowfocused)
            {
                var title = CHAT.title.html();
                if (title[0] != "*")
                {
                    CHAT.title.html("* " + title);
                    // win.title = CHAT.title.html();
                }
            }
            break;

        case "Event":
            $("div.chatroom[room='"+room+"']").append("<div class='"+type+"'><span class='timestamp'>["+lstamp+"]</span> "+content+"</div>\n");
            CHAT.removeOldMessages(room);
            CHAT.scrollToBottom();
            if (!CHAT.eventsshown) $("div.chatroom > div.Event").hide();
            break;

        case "Action":
            if (source == CHAT.selectedName) var spanclass = "user selected"; else var spanclass = "user";
            $("div.chatroom[room='"+room+"']").append("<div class='"+type+"'><span class='timestamp'>["+lstamp+"]</span> <span class='"+spanclass+"' user='"+source+"'>"+source+"</span> "+content+"</div>\n");
            CHAT.removeOldMessages(room);
            CHAT.scrollToBottom();
            break;
			
		case "Rainbow":
            if (source == USER.username && content[0] != "`") type += " Me";
            if (source == CHAT.selectedName) var spanclass = "user selected"; else var spanclass = "user";
            $("div.chatroom[room='"+room+"']").append("<div class='"+type+"'><span class='timestamp'>["+lstamp+"]</span> <span class='"+spanclass+"' user='"+source+"'>"+source+" : </span><span class='rainbowize'> "+content+"</span></div>\n");
            CHAT.removeOldMessages(room);
            CHAT.scrollToBottom();
            break;

        case "Private":
            if (source == CHAT.selectedName) var spanclass = "user selected"; else var spanclass = "user";
            $("div.chatroom").append("<div class='"+type+"'><span class='timestamp'>["+lstamp+"]</span> PM from <span class='"+spanclass+"' user='"+source+"'>"+source+"</span> : "+content+"</div>\n");
            CHAT.scrollToBottom();
            CHAT.lastPMsender = source;
            if (CHAT.isSoundEnabled && !CHAT.windowfocused)
            {
                CHAT.title.html("PM from " + source);
                // win.title = CHAT.title.html();
                CHAT.SOUNDS.blip.play();
            }
            break;

        case "ClanChat":
            if (source == CHAT.selectedName) var spanclass = "user selected"; else var spanclass = "user";
            $("div.chatroom").append("<div class='"+type+"'><span class='timestamp'>["+lstamp+"]</span> Clan Chat from <span class='"+spanclass+"' user='"+source+"'>"+source+"</span> : "+content+"</div>\n");
            CHAT.scrollToBottom();
            CHAT.lastPMsender = source;
            if (CHAT.isSoundEnabled && !CHAT.windowfocused)
            {
                CHAT.title.html("ClanChat from " + source);
                // win.title = CHAT.title.html();
                CHAT.SOUNDS.blip.play();
            }
            break;
        case "PrivateEcho":
            if (source == CHAT.selectedName) var spanclass = "user selected"; else var spanclass = "user";
            $("div.chatroom").append("<div class='"+type+"'><span class='timestamp'>["+lstamp+"]</span> PM to <span class='"+spanclass+"' user='"+source+"'>"+source+"</span> : "+content+"</div>\n");
            CHAT.scrollToBottom();
            CHAT.lastPMsender = source;
            break;

        case "Notice":
            $("div.chatroom.active").append("<div class='"+type+" Event'><span class='timestamp'>["+lstamp+"]</span> &mdash; "+content+"</div>\n");
            CHAT.scrollToBottom();
            if (!CHAT.eventsshown) $("div.chatroom > div.Event").hide();
            break;

        case "Alert":
            $("div.chatroom").append("<div class='"+type+"'><span class='timestamp'>["+lstamp+"]</span> [Armor Critical] "+content+" <span class='user'>("+source+")</span></div>\n");
            CHAT.scrollToBottom();
            if (!CHAT.windowfocused)
            {
                CHAT.title.html("* " + CHAT.pagetitle);
                // win.title = CHAT.title.html();
            }
            if (content.indexOf("!!!") != -1 && CHAT.isSoundEnabled) CHAT.SOUNDS.bugle.play();
            break;
    }
};

CHAT.removeOldMessages = function(room)
{
    var numberofmessages = $(".chatroom[room='" + room + "'] > div").length;
    if (numberofmessages > 1000) $(".chatroom[room='" + room + "'] > div:first").remove();
};

CHAT.updatePlayerList = function(roomname)
{
    CHAT.sortUsers(roomname);
    var html = "<table id='playerlisttable'>";
    for (var u in CHAT.ROOMS[roomname].users)
    {
        var user = CHAT.USERS[CHAT.ROOMS[roomname].users[u].username];
        if (user.clantag === null) user.clantag = "";
        if (user.afk) afkstring = "class='afk'"; else afkstring = "";
        if (user.ingame) ingamestring = "<img src='" + CHAT.webserver.host + "/images/ingame.png' />"; else ingamestring = "";
        if (user.perms == null) user.perms = "";
        if (typeof user.perms == 'string') user.perms = user.perms.split(",");
        var permicon = "";
        if ($.inArray('op', user.perms) >= 0) permicon = "blue";
        else if ($.inArray('dev', user.perms) >= 0) permicon = "grey";
        else if ($.inArray('admin', user.perms) >= 0) permicon = "red";
        else if ($.inArray('guide', user.perms) >= 0) permicon = "green";

        if (permicon !== "") permicon = "<img src='" + CHAT.webserver.host + "/images/icons/bullet_" + permicon + ".png' title='This user is a game " + user.perms[0] + ".' />";
        var perm = user.perms[0] != 'undefined' ? "class='" + user.perms[0] + "'" : "";

        if (typeof user.icons == 'string' && user.icons != "") user.icons = user.icons.split(",");
        var iconstring = "";
        for (var i in user.icons)
        {
            if (user.icons[i] !== '' && typeof user.icons[i] !== 'function')
                iconstring += "<img src='" + CHAT.webserver.host + "/images/icons/sicon" + user.icons[i] + ".png' />";
        }

        if (ingamestring == "") ingamestring = "&nbsp;"; // these lines fix table cell width in chrome
        if (user.tag == "") user.tag = "&nbsp;";
        if (iconstring == "") iconstring = "&nbsp;";

        html += "<tr username='" + user.username + "' " + afkstring + "><td class='col1'>" + ingamestring + "</td><td class='col2'>" + user.username + permicon + "</td><td class='col3'>" + user.tag + "</td><td class='col4'>" + iconstring + "</td></tr>";
    }
    html += "</table>";
    $("div.playerlist[room='"+roomname+"']").html(html);
    $("div#playerlistheader").html("Room: " + CHAT.activeRoom + " (" + CHAT.ROOMS[CHAT.activeRoom].users.length + ")");
};

CHAT.checkJavaVersion = function()
{
    exec("java -version", function(err, stdout, stderr)
    {
        console.log(stderr);
        if (!(stderr.includes("1.7") || stderr.includes("1.8") || stderr.includes("1.9")))
        {
            CHAT.launcherstatus = "update required";
            console.log("Java 1.7+ not found!");
            CHAT.launcherstatusdiv = $("<div id='launcherstatus'>* Java 1.7+ is required to play! <a href='https://www.java.com/en/download/' target='_blank'>Get it here</a>.</div>");
            CHAT.launcherstatusdiv.appendTo("body");
        }
    });
};

CHAT.updateGamesList = function()
{
    if (CHAT.timeout != null) return;
    for (var u in CHAT.USERS) CHAT.USERS[u].ingame = false; // clear each player's in-game status
    var html = "<table id='gamelisttable'>";
    if ($(document).width() < 1200) html = "<table id='gamelisttable' class='small'>";
    for (var g in CHAT.GAMES)
    {
        if (typeof CHAT.GAMES[g].Mapname != "undefined")
        {
            if (CHAT.GAMES[g].LaunchID == CHAT.activeGame) classstring = "active"; else classstring = "";
            var joinlink = "";
            if (CHAT.launcherstatus == "ready")
            {
                joinlink = "<a href='#' class='gamelink' data-gameindex='" + g + "' launchid='"+CHAT.GAMES[g].LaunchID+"'>Join</a>";
                if (CHAT.GAMES[g].Password == 1) joinlink = "<img class='padlock' src='" + CHAT.webserver.host + "/images/lock.png' title='Password required' />" + joinlink;
            } else joinlink = "*";
            var creator = CHAT.GAMES[g].Creator;
            if (creator == 'sparkhq') creator = 'ArmorCritical';
            html += "<tr launchid='"+CHAT.GAMES[g].LaunchID+"' class='"+classstring+"'><td class='col1'>"+CHAT.GAMES[g].Name+"</td><td class='col2'><span class='map_preview' href='"+escape(CHAT.GAMES[g].Mapname.replace(".map",""))+"' rel='lytebox'>"+CHAT.GAMES[g].Mapname.replace(".map","")+"</span></td><td class='col3'>"+CHAT.GAMES[g].Location+"</td><td class='col4'>"+creator+"</td><td class='col5'>"+(CHAT.GAMES[g].Players === undefined ? 0 : CHAT.GAMES[g].Players.length)+" / "+(CHAT.GAMES[g].MaxPlayers)+"</td><td class='col6'>"+joinlink+"</td></tr>";

            // update players' in-game status
            for (var p in CHAT.GAMES[g].Players)
            {
                if (typeof CHAT.USERS[CHAT.GAMES[g].Players[p].N] != 'undefined') CHAT.USERS[CHAT.GAMES[g].Players[p].N].ingame = true;
            }
        }
    }
    html += "</table>";
    $("div#gamelist").html(html);
    for (var r in CHAT.ROOMS) CHAT.updatePlayerList(r);
};

CHAT.updateGameInfoFrame = function(launchid)
{
    if (launchid in CHAT.GAMES)
    {
        CHAT.sortPlayers(launchid);
        var html = "<table id='gameinfotable'>";
        lastTeam = 0;
        playercount = 0;
        for (var p in CHAT.GAMES[launchid].Players)
        {
            var player = CHAT.GAMES[launchid].Players[p];
            if (player.T != lastTeam && !(player.T == -1 && playercount === 0))
            {
                html += "<tr class='teamscore'><td colspan='5'><div class='t"+lastTeam+"'>Score: "+CHAT.GAMES[launchid].TeamScores[lastTeam]+"</div></td></tr>";
                if (player.T > 0) playercount++;
                lastTeam = player.T;
            }
            html += "<tr class='team"+player.T+"'><td class='col1'>"+player.N+"</td><td class='col2'>" + (player.S > 0 ? "+":"") + player.S+"</td><td class='col3'>"+player.K+"</td><td class='col4'>"+player.D+"</td><td class='col5'>"+player.Mu+"</td></tr>";
        }
        if (lastTeam > 0) html += "<tr class='teamscore'><td colspan='5'><div class='t"+lastTeam+"'>Score: "+CHAT.GAMES[launchid].TeamScores[lastTeam]+"</div></td></tr>";
        html += "</table>";
        $("div#gameinfo").html(html);
    } else $("div#gameinfo").html("");
};

CHAT.updateRoomTopic = function(roomname, newtopic, source) {
    // If we're joining the room, we won't have any params passed.
    if (roomname == undefined) {
        roomname = CHAT.activeRoom;
        newtopic = CHAT.ROOMS[roomname].topic;
    }
    // If we're updating for the current room, we need to do some presentational things.
    if(CHAT.activeRoom == roomname)
    {
        CHAT.ROOMS[roomname].topic = newtopic;
        $("div#HeaderTopic").html(CHAT.ROOMS[roomname].topic == "" ? "&nbsp;" : CHAT.ROOMS[roomname].topic);
    } else
    {
        // If we're updating for a background room, it's much simpler.
        CHAT.ROOMS[roomname].topic = newtopic;
    }
};

CHAT.switchToRoom = function(roomname)
{
    $("div#chatroomtabs li[room='"+CHAT.activeRoom+"']").add("div.chatroom[room='"+CHAT.activeRoom+"']").add("div.playerlist[room='"+CHAT.activeRoom+"']").removeClass("active");
    CHAT.activeRoom = roomname;
    $("div#chatroomtabs li[room='"+CHAT.activeRoom+"']").add("div.chatroom[room='"+CHAT.activeRoom+"']").add("div.playerlist[room='"+CHAT.activeRoom+"']").addClass("active");
    $("div#chatroomtabs li[room='"+CHAT.activeRoom+"']").html(CHAT.activeRoom);
    $("div#playerlistheader").html("Room: " + CHAT.activeRoom + " (" + CHAT.ROOMS[roomname].users.length + ")");
    CHAT.updateRoomTopic();
    CHAT.scrollToBottom();
};

CHAT.joinRoom = function(roomname)
{
    request = {};
    request.action = "chatinput";
    request.activeroom = CHAT.activeRoom;
    request.content = '/join ' + roomname;
    CHAT.send(request);
};

CHAT.scrollToBottom = function()
{
    if (CHAT.scrolltoggle)
    {
        $(".chatroom.scroll").each(function()
        {
            $(this).scrollTop($(this).scrollHeight - $(this).height());
            $(this).prop({ scrollTop: $(this).prop("scrollHeight") }); // scroll to bottom
        });
    }
};

CHAT.setAFK = function(username, afkstatus)
{
    CHAT.USERS[username] = afkstatus;
    for (var r in CHAT.ROOMS)
    {
        var uindex = CHAT.findUserInRoom(r, username);
        if (uindex > -1) CHAT.ROOMS[r].users[uindex].afk = afkstatus;
        CHAT.updatePlayerList(r);
    }
};

CHAT.sendPM = function(message)
{
    request = {};
    request.action = "chatinput";
    request.activeroom = CHAT.activeRoom;
    request.content = message;
    CHAT.send(request);
};

CHAT.toLocalTime = function(timestamp)
{
    d = new Date(timestamp * 1000);
    timestring = new String(d.toLocaleTimeString());
    return timestring;
};

CHAT.openGame = function(gameindex)
{
    // CHAT.updateFiles();
    console.log("openGame: " + gameindex);
    if (typeof CHAT.GAMES[gameindex] == "undefined") return;
    var game = CHAT.GAMES[gameindex];
    if (CHAT.isAFK)
    {
        CHAT.isAFK = false;
        CHAT.setAFK = false;
        var request = {};
        request.action = "setafk";
        request.content = false;
        CHAT.send(request);
    }

    if (game.Password == 1 && CHAT.gamepasswordinput == "none")
    {
        CHAT.joininggame = gameindex;
        CHAT.showModal("#gamepasswordmodal");
        return;
    }

    var joinbutton = $(".gamelink[data-gameindex=" + gameindex + "]");
    joinbutton.html("Joining").addClass("disabled");
    $(".gamelink").not(joinbutton).hide();
    CHAT.timeout = setTimeout(function()
    {
        clearTimeout(CHAT.timeout);
        CHAT.timeout = null;
        $(".gamelink").removeClass("disabled").html("Join").show();
    }, 15000);

    if (typeof CHAT.gamepasswordinput == 'number') CHAT.gamepasswordinput = CHAT.gamepasswordinput.toString();
    var joinstring = JSON.stringify({"Username":USER.username,"Hash":USER.gamekey,"IPAddress":game.IPAddress,"Port":game.Port,"Password":CHAT.gamepasswordinput,"CRC":0});
    var app = "java -Dorg.lwjgl.util.Debug=true -Dsun.java2d.noddraw=true -Dsun.java2d.d3d=false -Dsun.java2d.opengl=false -Dorg.lwjgl.opengl.Display.allowSoftwareOpenGL=true -Dsun.java2d.dpiaware=false -Djava.library.path=\"" + rootPath + "/java/natives-" + CHAT.os + "\" -jar \"" + rootPath + "/java/spark.jar\" " + "\"" + joinstring + "\"" + " " + "\"" + JSON.stringify(USER.gameoptions) + "\"";

    errlog(app);
    exec(app, function(err,stdout,stderr) {
        if (err != '') errlog(err);
        if (stdout != '') errlog(stdout);
        if (stderr != '') errlog(stderr);
    });
    CHAT.gamepasswordinput = "none";
    CHAT.joininggame = null;
};

CHAT.findUserInRoom = function(roomname, username)
{
    for (var u in CHAT.ROOMS[roomname].users)
    {
        if (CHAT.ROOMS[roomname].users[u].username == username)
        {
            return u;
        }
    }
    return -1;
};

CHAT.sortUsers = function(roomname) // sorts the list of users in a room
{
    CHAT.ROOMS[roomname].users.sort(function(a,b)
    {
        if (a.perms == null) return 1;
        if (b.perms == null) return -1;
        a = CHAT.USERS[a.username];
        b = CHAT.USERS[b.username];
        if (a.afk && !b.afk) return 1;
        else if (!a.afk && b.afk) return -1;
        else if (a.ingame && !b.ingame) return 1;
        else if (!a.ingame && b.ingame) return -1;
        else if (a.perms[0] != "op" && b.perms[0] == "op") return 1;
        else if (b.perms[0] != "op" && a.perms[0] == "op") return -1;
        else if (a.perms[0] != "admin" && b.perms[0] == "admin") return 1;
        else if (b.perms[0] != "admin" && a.perms[0] == "admin") return -1;
        else if (a.perms[0] != "guide" && b.perms[0] == "guide") return 1;
        else if (b.perms[0] != "guide" && a.perms[0] == "guide") return -1;
        else if (a.perms[0] != "dev" && b.perms[0] == "dev") return 1;
        else if (b.perms[0] != "dev" && a.perms[0] == "dev") return -1;
        return a.username.toLowerCase().localeCompare(b.username.toLowerCase());
    });
};

CHAT.sortPlayers = function(launchid) // sorts the list of players in a game
{
    if (typeof CHAT.GAMES[launchid].Players != "undefined")
    {
        CHAT.GAMES[launchid].Players.sort(function(a,b)
        {
            if (a.T == b.T)
            {
                if (a.Mu == b.Mu) return a.N.localeCompare(b.N);
                return (a.Mu > b.Mu) ? -1 : 1;
            }
            else if (a.T == -1) return 1;
            else if (b.T == -1) return -1;
            return (a.T < b.T) ? -1 : 1;
        });
    }
};

CHAT.openNewGameModal = function()
{
    $("#newGameButton").html(" ... ");
    $.post(CHAT.webserver.host + "/api/getmaps", function(response)
    {
        var html = "";
        var map;
        for (var m in response.recentmaps)
        {
            map = response.recentmaps[m];
            html += '<option value="' + map + '.map">' + map + '</option>';
        }
        html += '<option disabled>───────────────────────────</option>';
        for (var m in response.allmaps)
        {
            map = response.allmaps[m];
            html += '<option value="' + map + '.map">' + map + '</option>';
        }
        $("#newgame_map").html(html);
        CHAT.showModal("#newgamemodal");
        $("#newGameButton").html("Create Game");
    }, 'json');
};

CHAT.setUserInfo = function(response)
{
    USER.username = response.username;
    USER.userkey = response.userkey;
    USER.gamekey = response.gamekey;
    USER.sitekey = response.sitekey;
    USER.permissions = typeof response.permissions == 'string' && response.permissions != '' ? response.permissions.split(",") : [];
};

CHAT.hasPermission = function(perm)
{
    return (USER.permissions.indexOf(perm) !== -1);
};

CHAT.saveUserFile = function()
{
    fs.writeFileSync(path.join(rootPath, 'user.json'), JSON.stringify(USER));
};

// CHAT.updateFile = function(remotefile, localfile)
// {
//     // if (typeof domain !== 'undefined' && domain == "") return;
//     console.log("Updating file: " + remotefile);
//     http.get({hostname:CHAT.chatserver.host, path:"/" + CHAT.remotepath + remotefile}, function(response) {
//         response.pipe(fs.createWriteStream(localfile));
//     }).on('error', function(e) { console.dir(e); });
// };
//
// CHAT.updateFiles = function()
// {
//     $.post(CHAT.hashurl, function(filehashes)
//     {
//         for (var filename in filehashes)
//         {
//             try
//             {
//                 CHAT.hashfile(filename, function(filename, hash)
//                 {
//                     if (hash != filehashes[filename]) CHAT.updateFile(filename, filename);
//                 });
//             } catch (e) { CHAT.updateFile(filename, filename); }
//         }
//     }, 'json');
// };

CHAT.hashfile = function(filename, callback)
{
    try
    {
        fs.stat(filename, function(err, stats)
        {
            if (err) callback(filename, "");
            else
            {
                var fd = fs.createReadStream(filename);
                var hash = crypt.createHash('md5');
                hash.setEncoding('hex');
                fd.on('end', function() {
                    hash.end();
                    callback(filename, hash.read());
                });
                fd.pipe(hash);
            }
        });
    } catch (e) { callback(filename, ""); }
};

var htmlEntities = function(str)
{
    return String(str).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
};

var filterString = function(line)
{
    if (typeof line == "object") line = line.join(" ");
    line = htmlEntities(line);
    line = line.replace(/((mailto:|(news|(ht|f)tp(s?)):\/\/){1}\S+)/g, "<a href='$1' target='_blank'>$1</a>");
    line = line.replace(/(n[i|l|!]gg\S*)/i, "<span class='censored'>$1</span>");
    line = line.replace(/(f\Sgg?[o|0]t)/i, "<span class='censored'>$1</span>");
    return line;
};

var css_browser_selector = function(u) {var ua=u.toLowerCase(),is=function(t){return ua.indexOf(t)>-1},g='gecko',w='webkit',s='safari',o='opera',m='mobile',h=document.documentElement,b=[(!(/opera|webtv/i.test(ua))&&/msie\s(\d)/.test(ua))?('ie ie'+RegExp.$1):is('firefox/2')?g+' ff2':is('firefox/3.5')?g+' ff3 ff3_5':is('firefox/3.6')?g+' ff3 ff3_6':is('firefox/3')?g+' ff3':is('gecko/')?g:is('opera')?o+(/version\/(\d+)/.test(ua)?' '+o+RegExp.$1:(/opera(\s|\/)(\d+)/.test(ua)?' '+o+RegExp.$2:'')):is('konqueror')?'konqueror':is('blackberry')?m+' blackberry':is('android')?m+' android':is('chrome')?w+' chrome':is('iron')?w+' iron':is('applewebkit/')?w+' '+s+(/version\/(\d+)/.test(ua)?' '+s+RegExp.$1:''):is('mozilla/')?g:'',is('j2me')?m+' j2me':is('iphone')?m+' iphone':is('ipod')?m+' ipod':is('ipad')?m+' ipad':is('mac')?'mac':is('darwin')?'mac':is('webtv')?'webtv':is('win')?'win'+(is('windows nt 6.0')?' vista':''):is('freebsd')?'freebsd':(is('x11')||is('linux'))?'linux':'','js']; c = b.join(' '); h.className += ' '+c; return c;};

var flashnotice = function(notice)
{
    if (notice == null || notice == "") return;
    var fn = $("#flashnotice");
    fn.html(notice).css("left", (window.innerWidth / 2) - (fn.width() / 2)).show().delay(10000).fadeOut();
};

var RGBtoInt = function(r,g,b)
{
    return (255 << 24) | (r << 16) | (g << 8) | (b);
};

var IntToHex = function(i)
{
    if (typeof i == "string") i = parseInt(i);
    var color = i & 16777215;
    return "#" + color.toString(16).toUpperCase().lpad("0",6);
};

String.prototype.lpad = function(padString, length)
{
    var str = this;
    while (str.length < length) str = padString + str;
    return str;
};

var keynames = {
    8:"backspace",
    9:"tab",
    10:"enter",
    13:"enter",
    16:"shift",
    17:"ctrl",
    18:"alt",
    19:"pause/break",
    20:"caps lock",
    //27:"escape",
    32:"space",
    33:"page up",
    34:"page down",
    35:"end",
    36:"home",
    37:"left arrow",
    38:"up arrow",
    39:"right arrow",
    40:"down arrow",
    44:",",
    45:"insert",
    46:"delete",
    48:"0",
    49:"1",
    50:"2",
    51:"3",
    52:"4",
    53:"5",
    54:"6",
    55:"7",
    56:"8",
    57:"9",
    65:"a",
    66:"b",
    67:"c",
    68:"d",
    69:"e",
    70:"f",
    71:"g",
    72:"h",
    73:"i",
    74:"j",
    75:"k",
    76:"l",
    77:"m",
    78:"n",
    79:"o",
    80:"p",
    81:"q",
    82:"r",
    83:"s",
    84:"t",
    85:"u",
    86:"v",
    87:"w",
    88:"x",
    89:"y",
    90:"z",
    91:"left window",
    92:"right window",
    93:"select",
    96:"num 0",
    97:"num 1",
    98:"num 2",
    99:"num 3",
    100:"num 4",
    101:"num 5",
    102:"num 6",
    103:"num 7",
    104:"num 8",
    105:"num 9",
    106:"num *",
    107:"num +",
    109:"num -",
    110:"num .",
    111:"num /",
    112:"f1",
    113:"f2",
    114:"f3",
    115:"f4",
    116:"f5",
    117:"f6",
    118:"f7",
    119:"f8",
    120:"f9",
    121:"f10",
    122:"f11",
    123:"f12",
    127:"delete",
    144:"num lock",
    145:"scroll lock",
    186:";",
    187:"=",
    188:",",
    189:"-",
    190:".",
    191:"/",
    192:"`",
    219:"[",
    220:"\\",
    221:"]",
    222:"'",
    255:"windows key"
};

var initApp = function()
{
    css_browser_selector(navigator.userAgent);
    if ($("html").hasClass("linux")) CHAT.os = "linux";
    if ($("html").hasClass("mac")) CHAT.os = "mac";

    CHAT.checkJavaVersion();
    CHAT.title = $("title");
    CHAT.windowfocused = true;
    if ($(document).width() < 1200) $("#gamelistframe table").addClass("small");
    $("#flashnoticedismiss").click(function() { $("#flashnotice").hide(); });

    $(window).focus(function()
    {
        CHAT.windowfocused = true;
        CHAT.title.html(CHAT.pagetitle);
        // win.title = CHAT.title.html();
        $("input#chatinput").focus();
    });
    $(window).blur(function()
    {
        CHAT.windowfocused = false;
        $("div.chatroom hr").remove(); // remove previous horizontal rules
        $("div.chatroom").append("<hr size='1' />"); // add horizontal rule to mark last line of chat
        CHAT.scrollToBottom();
    });

    $("a#close-panel").click(function()
    {
        $("#lightbox-panel").slideToggle(300);
        $("#lightbox").fadeOut(300);
    });

    $(document).mousemove(function()
    {
        if (CHAT.time > CHAT.afkdelay && !CHAT.setToAFK)
        {
            CHAT.AFKTimer = CHAT.time + 600000;

            if (CHAT.isAFK)
            {
                // user is in auto-afk mode and mouse was moved; send setafk and reset afk timer
                var request = {};
                request.action = "setafk";
                request.content = false;
                CHAT.send(request);
                CHAT.afkdelay = CHAT.time + 2000;
            }
        }
    });

    $(window).resize(function()
    {
        if (CHAT.activemodal !== null) CHAT.positionModal();
    });

    $(document).on('click', "div#chatframe", function() // clicking anywhere in the chatframe gives focus to chatinput
    {
        $("input#chatinput").focus();
    });

    $(document).on('dblclick', "table#playerlisttable tr", function() // double-clicking on names in the player list starts a pm
    {
        $("input#chatinput").focus();
        $("input#chatinput").val("/pm " + $(this).attr("username") + " ");
    });

    $(document).on('click', "table#gamelisttable tr", function() // clicking on a game shows info in gameinfoframe
    {
        CHAT.activeGame = $(this).attr("LaunchID");
        CHAT.updateGameInfoFrame(CHAT.activeGame);
        $("table#gamelisttable tr").removeClass("active");
        $(this).addClass("active");
    });

    $(document).on('click', "div span.user", function()
    {
        var user = $(this).attr("user");
        if (CHAT.selectedName == user)
        {
            CHAT.selectedName = "";
            $("div span.user").removeClass("selected");
        } else
        {
            $("div span.user").removeClass("selected");
            CHAT.selectedName = user;
            $("span.user[user='"+user+"']").addClass("selected");
        }
    });

    $(document).on('dblclick', "div span.user", function()
    {
        $("input#chatinput").val("/pm " + $(this).attr("user") + " ");
    });

    // Make the map names clickable
    $('#gamelist').on('click', '.map_preview', function(e)
    {
        e.preventDefault();
        var map = $(e.target).attr('href');
        $("#mappreviewname").html(map);
        var img = $("<img>");
        img.load(function()
        {
            $("#mappreviewimage").html(img);
            CHAT.showModal("#mappreviewmodal");
        }).attr("src", CHAT.webserver.host + "/maps/images/" + map + ".png");
    });

    var audio = document.createElement("audio");
    if (typeof audio.canPlayType == "function")
    {
        if (audio.canPlayType("audio/ogg") != "")
        {
            CHAT.SOUNDS.blip = new Audio(path.join(rootPath, 'sounds/blip.ogg'));
            CHAT.SOUNDS.bugle = new Audio(path.join(rootPath, 'sounds/bugle.ogg'));
            $(this).html("disable sounds");
            CHAT.isSoundEnabled = true;
        } else
        if (audio.canPlayType("audio/mpeg") != "")
        {
            CHAT.SOUNDS.blip = new Audio(path.join(rootPath, 'sounds/blip.mp3'));
            CHAT.SOUNDS.bugle = new Audio(path.join(rootPath, 'sounds/bugle.mp3'));
            $(this).html("disable sounds");
            CHAT.isSoundEnabled = true;
        } else CHAT.SOUNDS = null;
    } else CHAT.SOUNDS = null;
    if (CHAT.SOUNDS == null) // audio is not supported
    {
        $("#soundtoggle").remove();
        CHAT.isSoundEnabled = false;
    } else
    {
        $("#soundtoggle").click(function() // turn chat sounds on/off
        {
            if (CHAT.isSoundEnabled)
            {
                $(this).html("enable sounds");
                CHAT.isSoundEnabled = false;
            } else
            {
                $(this).html("disable sounds");
                CHAT.isSoundEnabled = true;
            }
        });
    }

    CHAT.scrolltoggle = true;
    $("#scrolltoggle").click(function() // turn chat scrolling on/off
    {
        if (CHAT.scrolltoggle)
        {
            $(this).html("enable scrolling");
            CHAT.scrolltoggle = false;
        } else
        {
            $(this).html("disable scrolling");
            CHAT.scrolltoggle = true;
        }
    });

    CHAT.eventsshown = true;
    $("#eventstoggle").click(function() // show/hide events button
    {
        if (CHAT.eventsshown)
        {
            $("div.chatroom > div.Event").hide();
            $(this).html("show events");
            CHAT.eventsshown = false;
        } else
        {
            $("div.chatroom > div.Event").show();
            $(this).html("hide events");
            CHAT.eventsshown = true;
        }
    });

    CHAT.stampsshown = true;
    $("#stampstoggle").click(function() // show/hide timestamps button
    {
        if (CHAT.stampsshown)
        {
            $("div.chatroom span.timestamp").hide();
            $(this).html("show timestamps");
            CHAT.stampsshown = false;
        } else
        {
            $("div.chatroom span.timestamp").show();
            $(this).html("hide timestamps");
            CHAT.stampsshown = true;
        }
    });

    $(document).on('click', "#chatroomtabs li", function() // room tabs
    {
        CHAT.switchToRoom($(this).attr("room"));
    });

    $(document).on('click', ".gamelink", function(e)
    {
        e.preventDefault();
        if (!$(this).hasClass("disabled"))
        {
            //$(this).html("Joining").addClass("disabled");
            //$(".gamelink").not(this).hide();
            //CHAT.timeout = setTimeout(function()
            //{
            //    clearTimeout(CHAT.timeout);
            //    CHAT.timeout = null;
            //    $(".gamelink").removeClass("disabled").html("Join").show();
            //}, 15000);
            var gameindex = $(this).attr("data-gameindex");
            CHAT.openGame(gameindex);
        }
        return false;
    });

    $(document).on('click', "#passwordjoinbutton", function()
    {
        CHAT.gamepasswordinput = $("#gamepasswordinput").val();
        if (CHAT.gamepasswordinput == "" || CHAT.joininggame == null) return;
        CHAT.hideModal();
        CHAT.openGame(CHAT.joininggame);
    });

    // Make anchor tags work properly in node/webkit
    $(document).on('click', 'a[target=_blank]', function()
    {
        shell.openExternal( this.href );
        return false;
    });

    $(document).on('click', 'a.openwindow', function()
    {
        // gui.Window.open(this.href, {position:'center', width:1000, height:600});
        return false;
    });

    // Modal stuff
    $(document).on('click', '.hidemodal', function(e) { e.preventDefault(); CHAT.hideModal(); return false; });
    $(document).on('click', '#modalbg', CHAT.hideModal);
    $(document).on('click', '.modalbutton', function(e) {
        e.preventDefault();
        var modal = $(this).attr("data-modal");
        CHAT.showModal("#" + modal);
        return false;
    });

    $('#newgamebutton').click(CHAT.openNewGameModal);

    $('#savesettingsbutton').click(function()
    {
        var buttonlabel = $(this).html();
        $(this).html("Saving...");
        $(".settings input").each(function()
        {
            var option = $(this).attr("name");
            if (option in USER.gameoptions)
            {
                if ($(this).hasClass("key"))
                {
                    USER.gameoptions[option] = $(this).attr("keycode");
                    if (USER.gameoptions[option] == "46" || USER.gameoptions[option] == 46) USER.gameoptions[option] = "127"; // convert js delete code to java delete code
                    if (USER.gameoptions[option] == "188" || USER.gameoptions[option] == 188) USER.gameoptions[option] = "44"; // convert js comma code to java comma code
                    if (USER.gameoptions[option] == "93" || USER.gameoptions[option] == 93) USER.gameoptions[option] = "525";
                } else
                if ($(this).hasClass("color"))
                {
                    USER.gameoptions[option] = $(this).attr("colorcode");
                } else
                if ($(this).hasClass("number"))
                {
                    USER.gameoptions[option] = $(this).val();
                } else // checkbox
                {
                    if ($(this).prop("checked")) USER.gameoptions[option] = "true";
                    else USER.gameoptions[option] = "false";
                }
            }
        });
        $(".settings select").each(function()
        {
            var option = $(this).attr("name");
            if (option in USER.gameoptions)
            {
                USER.gameoptions[option] = $(this).val();
            }
        });
        CHAT.saveUserFile();
        $(this).html(buttonlabel);
        CHAT.hideModal();
    });

    $('#createaccountlink').click(function()
    {
        $('#loginmodal>.row>.col-6').hide();
        $('#registerform').show();
        CHAT.positionModal();
    });

    $('.signinlink').click(function()
    {
        $('#loginmodal>.row>.col-6').hide();
        $('#signinform').show();
        CHAT.positionModal();
    });

    $('#lostpasswordlink').click(function()
    {
        $('#loginmodal>.row>.col-6').hide();
        $('#lostpasswordform').show();
        CHAT.positionModal();
    });

    $("#registerbutton").click(function(e)
    {
        e.preventDefault();
        var request = $('#registerform form').serialize();
        $.post(CHAT.webserver.host + "/account/register", request, function(response)
        {
            switch (response.action)
            {
                case "error":
                    flashnotice(response.message);
                    break;
                case "redirect":
                    USER.username = response.username;
                    USER.userkey = response.userkey;
                    USER.gamekey = response.gamekey;
                    USER.sitekey = response.sitekey;
                    CHAT.connect();
                    break;
            }
        }, 'json');
        return false;
    });

    $("#lostpasswordbutton").click(function(e)
    {
        e.preventDefault();
        var request = $('#lostpasswordform form').serialize();
        $.post(CHAT.webserver.host + "/account/lostpassword", request, function(response)
        {
            switch (response.action)
            {
                case "error":
                    flashnotice(response.message);
                    break;
                case "redirect":
                    USER.username = response.username;
                    USER.userkey = response.userkey;
                    USER.gamekey = response.gamekey;
                    USER.sitekey = response.sitekey;
                    CHAT.connect();
                    break;
            }
        }, 'json');
        return false;
    });

    $('#signinbutton').click(function(e)
    {
        e.preventDefault();
        CHAT.reconnectattempts = 12;
        var request = $('#signinform form').serialize();
        USER.keepsignedin = $("#srememberme").is(':checked');
        $.post(CHAT.webserver.host + "/account/signin", request, function(response)
        {
            switch (response.action)
            {
                case "error":
                    flashnotice(response.message);
                    break;
                case "displayusernames":
                    var html = "";
                    for (var u in response.usernames)
                        html += "<li class='username' username='"+response.usernames[u]+"'>"+response.usernames[u]+"</li>";
                    for (var n=response.usernames.length; n < 4; n++)
                        html += "<li class='empty'>&nbsp;</li>";
                    if (response.usernames.length < 5)
                        html += "<li class='newuser'><input type='text' value='Create a new username...' name='newusername' id='newusername' /><div id='newusernamecreate'>+</div></li>";
                    $("#userselectiondiv ul").html(html);
                    $("#newusername").focus(function() { $(this).val("").attr("maxlength", "20"); });
                    $("#newusernamecreate").click(function()
                    {
                        var newusername = $("#newusername").val();
                        if (newusername != "")
                        {
                            if (confirm("Each account is limited to 5 usernames.  Are you sure you want to create \"" + newusername + "\"?"))
                            {
                                $.post(CHAT.webserver.host + '/account/signin/', {'newusername':newusername}, function(response)
                                {
                                    switch (response.action)
                                    {
                                        case 'error':
                                            if (typeof response.message != 'undefined') flashnotice(response.message);
                                            else flashnotice("Unspecified error.");
                                            break;
                                        case 'redirect':
                                            CHAT.setUserInfo(response);
                                            CHAT.connect();
                                            break;
                                        default:
                                    }
                                }, 'json');
                            }
                        }
                    });

                    $("#userselectiondiv li.username").click(function()
                    {
                        $.post(CHAT.webserver.host + '/account/signin/', {'susername':$(this).attr('username')}, function(response)
                        {
                            switch (response.action)
                            {
                                case 'error':
                                    if (typeof response.message != 'undefined') flashnotice(response.message);
                                    else flashnotice("Unspecified error.");
                                    break;
                                case 'redirect':
                                    CHAT.setUserInfo(response);
                                    CHAT.connect();
                                    break;
                                default:
                            }
                        }, 'json');
                    });

                    $('#signinform').hide();
                    $('#usernameselectionform').show();
                    CHAT.positionModal();
                    break;
                case "redirect":
                    CHAT.setUserInfo(response);
                    CHAT.connect();
                    break;
            }
        }, 'json');
        return false;
    });

    $("#signoutbutton").click(function(e)
    {
        e.preventDefault();
        $.post(CHAT.webserver.host + "/account/signout");
        CHAT.send({"action":"disconnect"});
        CHAT.reconnectattempts = 0;
        if (typeof CHAT.socket.disconnect == 'function')
            CHAT.socket.disconnect();
        CHAT.connected = false;
        USER.keepsignedin = false;
        CHAT.saveUserFile();

        for (var r in CHAT.ROOMS)
        {
            if (r == "lobby") continue;
            delete CHAT.ROOMS[r];
            $("div#chatroomtabs li[room='"+r+"']").remove();
            $("div.chatroom[room='"+r+"']").remove();
            $("div.playerlist[room='"+r+"']").remove();
        }
        CHAT.switchToRoom("lobby");
        CHAT.showModal("#loginmodal");
        $('.signinlink').click();
    });

    // Game Creation bindings
    //
    // Fill in a default game name to speed up the game creation process
    $('#newgame_map').change(function()
    {
        $('#newgame_name').val($('#newgame_map option:selected').text());
    });

    // Make the Create Game button get the data and send it as a text command
    $('#newGameCreateButton').click(function(e)
    {
        e.preventDefault();
        var gameData = {};
        gameData.map 			= $('#newgame_map option:selected').val();
        gameData.name 			= $('#newgame_name').val();
        gameData.hub 			= $('#newgame_hub option:selected').val();
        gameData.maxPlayers 	= $('#newgame_players').val();
        gameData.password 		= $('#newgame_password').val();

        var errors = "";
        if (gameData.name == '') errors += "Please enter a game name\n";

        if (errors != "")
        {
            alert(errors);
            return;
        };

        // Spec is: /game "(hub name)" "(game name)" "(map name)" (player limit) "(password)"
        var message = '/game '
        message += '"' + gameData.hub + '" ';
        message += '"' + gameData.name + '" ';
        message += '"' + gameData.map + '" ';
        message += gameData.maxPlayers + ' ';
        message += '"' + gameData.password + '" ';

        request = {};
        request.action = "chatinput";
        request.activeroom = CHAT.activeRoom;
        request.content = message;
        console.log(message);
        CHAT.send(request);

        CHAT.hideModal();
    });

    // Game settings bindings
    var inputcolors = $('.settings input.color');
    inputcolors.ColorPicker(
        {
            onSubmit: function(hsb, hex, rgb, el)
            {
                var color = "#"+hex.toUpperCase();
                $(el).val(color);
                $(el).css("background-color", color);
                var intcolor = parseInt(color.replace("#",""),16);
                var brightness = ((intcolor & 0xF00000) >> 20) + ((intcolor & 0x00F000) >> 12) + ((intcolor & 0x0000F0) >> 4);
                if (brightness >= 24) $(el).addClass("invert");
                else $(el).removeClass("invert");
                $(el).attr("colorcode", (255 << 24) + parseInt(hex,16));
                $(el).ColorPickerHide();
            },
            onBeforeShow: function ()
            {
                $(this).ColorPickerSetColor(this.value);
            }
        });

    inputcolors.keyup(function(event)
    {
        var color = $(this).val().replace("#","").toUpperCase();
        $(this).val("#"+color);
        if (color.length >= 6)
        {
            $(this).css("background-color", "#"+color);
            var intcolor = (255 << 24) + parseInt(color,16);
            var brightness = ((intcolor & 0xF00000) >> 20) + ((intcolor & 0x00F000) >> 12) + ((intcolor & 0x0000F0) >> 4);
            if (brightness >= 24) $(this).addClass("invert");
            else $(this).removeClass("invert");
            $(this).attr("colorcode", intcolor);
        } else
        {
            $(this).css("background-color", "black");
        }
    });

    inputcolors.blur(function(event)
    {
        $(this).css("background-color", $(this).val());
    });

    var inputnumber = $(".settings input.number");
    inputnumber.keyup(function(event)
    {
        var number = parseFloat($(this).val());
        var maxvalue = parseFloat($(this).attr("maxvalue"));
        var minvalue = parseFloat($(this).attr("minvalue"));

        if (number > maxvalue) $(this).val(maxvalue);
        if (number < minvalue) $(this).val(minvalue);
    });

    inputnumber.blur(function(event)
    {
        var number = parseFloat($(this).val());
        var maxvalue = parseFloat($(this).attr("maxvalue"));
        var minvalue = parseFloat($(this).attr("minvalue"));
        var fixed = parseInt($(this).attr("fixed"));

        if (number > maxvalue) $(this).val(maxvalue);
        if (number < minvalue) $(this).val(minvalue);
        $(this).val((parseFloat($(this).val())).toFixed(fixed));
    });

    $(".settings input.key").keydown(function(event)
    {
        if (event.keyCode in keynames)
        {
            $(this).val(keynames[event.keyCode]);
            $(this).attr("keycode", event.keyCode);
            if (event.keyCode == 13) $(this).attr("keycode", 10); // js 13 converts to java 10
            return false;
        }
    });

    // load user's settings
    $(".settings input").each(function()
    {
        var option = $(this).attr("name");
        if (option in USER.gameoptions)
        {
            if (USER.gameoptions[option] == "true") $(this).prop("checked", true);
            else if (USER.gameoptions[option] == "false") $(this).prop("checked", false);
            else // text input
            {
                if ($(this).hasClass("key"))
                {
                    $(this).val(keynames[USER.gameoptions[option]]);
                    $(this).attr("keycode", USER.gameoptions[option]);
                } else
                if ($(this).hasClass("color"))
                {
                    var color = IntToHex(USER.gameoptions[option]);
                    $(this).val(color).css("background-color",color);
                    var intcolor = parseInt(color.replace("#",""),16);
                    var brightness = ((intcolor & 0xF00000) >> 20) + ((intcolor & 0x00F000) >> 12) + ((intcolor & 0x0000F0) >> 4);
                    if (brightness >= 24) $(this).addClass("invert");
                    else $(this).removeClass("invert");
                    $(this).attr("colorcode", USER.gameoptions[option]);
                    $(this).ColorPickerSetColor(color);
                } else
                if ($(this).hasClass("number"))
                {
                    $(this).val(USER.gameoptions[option]);
                }
            }
        }
    });

    $(".settings select").each(function()
    {
        var option = $(this).attr("name");
        if (option in USER.gameoptions) $(this).val(USER.gameoptions[option]);
    });

    $("input#chatinput").keyup(function(event)
    {
        if (event.keyCode == 32)
        {
            if ($(this).val().toLowerCase() == "/r ")
            {
                if (CHAT.lastPMsender == "") $(this).val("/pm ");
                else $(this).val("/pm " + CHAT.lastPMsender + " ");
                return;
            }
        }
        if (event.keyCode == 38) // up arrow key; scrolls back through previous input lines
        {
            if (CHAT.inputlines.length > CHAT.inputlinescursor+1)
            {
                if (CHAT.inputlinescursor==-1)
                {
                    CHAT.inputlines.unshift($.trim($(this).val())); // add line to beginning of list
                    if (CHAT.inputlines.length > 20) CHAT.inputlines.pop(); // remove last line from list
                    CHAT.inputlinescursor++;
                }
                CHAT.inputlinescursor++;
                $(this).val(CHAT.inputlines[CHAT.inputlinescursor]);
            }
        } else if (event.keyCode == 40) // down arrow key
        {
            if (CHAT.inputlinescursor > 0)
            {
                CHAT.inputlinescursor--;
                $(this).val(CHAT.inputlines[CHAT.inputlinescursor]);
            }
        }
    });

    // Chat input field
    $("input#chatinput").keypress(function(event)
    {
        if (event.keyCode == 13 && $(this).val()!=="") // enter key
        {
            if ($.trim($(this).val()).toLowerCase() == "/r")
            {
                $(this).val("/pm " + CHAT.lastPMsender + " ");
                return;
            }

            if ($.trim($(this).val()).toLowerCase() == "/clear")
            {
                $(".chatroom.active").html("");
                $(this).val("");
                return;
            }

            if ($.trim($(this).val()).toLowerCase() == "/afk")
            {
                request = {};
                request.action = "setafk";
                request.content = !CHAT.isAFK;
                CHAT.send(request);

                CHAT.setToAFK = !CHAT.isAFK;
            }

            var d = (new Date()).getTime();
            if (d > CHAT.chatInputTimer)
            {
                CHAT.chatInputTimer = d + 1000; // 1-second chat input delay
                request = {};
                request.action = "chatinput";
                request.activeroom = CHAT.activeRoom;
                request.content = $.trim($(this).val());

                if (request.content.toLowerCase() == "/clear") $(".chatroom.active").html("");
                if (request.content.toLowerCase() == "/leave") request.content = "/leave " + CHAT.activeRoom;
                if (request.content.toLowerCase() == "/part") request.content = "/leave " + CHAT.activeRoom;
                var fields = request.content.split(" ");
                if ((new String(fields[0])).toLowerCase() == "/password" && fields.length == 2)
                {
                    request.content = fields[0] + " " + CHAT.activeRoom + " " + fields[1];
                }

                CHAT.send(request);
                if (!CHAT.isAFK) CHAT.AFKTimer = CHAT.time + 600000;
                CHAT.inputlines.unshift(request.content); // add line to beginning of list
                if (CHAT.inputlines.length > 20) CHAT.inputlines.pop(); // remove last line from list
                CHAT.inputlinescursor = -1;
                $(this).val("");
            }
        }
    });
}

    // user closes window or moves away from page
    window.addEventListener("beforeunload", function () { CHAT.send({"action":"disconnect"}); } );

    var d = (new Date()).getTime();
    CHAT.chatInputTimer = d + 2000; // 2-second chat input delay to wait for init to complete
    CHAT.initialConnectTimer = d + 10000;



    // Main start of application.
    //
    $(document).ready(function() {
        loadAssets(function() {
            loadUserSettings();
            initApp();
            if (USER.keepsignedin) CHAT.connect();
            else CHAT.reconnectattempts = 0; // must be 0 for CHAT.loop to display login modal
            setInterval(CHAT.loop, 1000);
        })       
    });

   
    // setInterval(CHAT.updateFiles, 300000);
    // CHAT.updateFiles();
    // gui.Window.get().show();



    // After app is up and running, update files
    // if (domain != "") CHAT.updateFiles();

