/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.CodeBook;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncResidue;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.InfoResidue0;
import com.jcraft.jorbis.LookResidue0;

class Residue0
extends FuncResidue {
    static int[][][] partword = new int[2][][];

    Residue0() {
    }

    void pack(Object object, Buffer buffer) {
        InfoResidue0 infoResidue0 = (InfoResidue0)object;
        int n = 0;
        buffer.write(infoResidue0.begin, 24);
        buffer.write(infoResidue0.end, 24);
        buffer.write(infoResidue0.grouping - 1, 24);
        buffer.write(infoResidue0.partitions - 1, 6);
        buffer.write(infoResidue0.groupbook, 8);
        int n2 = 0;
        while (n2 < infoResidue0.partitions) {
            if (Residue0.ilog(infoResidue0.secondstages[n2]) > 3) {
                buffer.write(infoResidue0.secondstages[n2], 3);
                buffer.write(1, 1);
                buffer.write(infoResidue0.secondstages[n2] >>> 3, 5);
            } else {
                buffer.write(infoResidue0.secondstages[n2], 4);
            }
            n += Residue0.icount(infoResidue0.secondstages[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            buffer.write(infoResidue0.booklist[n3], 8);
            ++n3;
        }
    }

    Object unpack(Info info, Buffer buffer) {
        int n;
        int n2 = 0;
        InfoResidue0 infoResidue0 = new InfoResidue0();
        infoResidue0.begin = buffer.read(24);
        infoResidue0.end = buffer.read(24);
        infoResidue0.grouping = buffer.read(24) + 1;
        infoResidue0.partitions = buffer.read(6) + 1;
        infoResidue0.groupbook = buffer.read(8);
        int n3 = 0;
        while (n3 < infoResidue0.partitions) {
            n = buffer.read(3);
            if (buffer.read(1) != 0) {
                n |= buffer.read(5) << 3;
            }
            infoResidue0.secondstages[n3] = n;
            n2 += Residue0.icount(n);
            ++n3;
        }
        n = 0;
        while (n < n2) {
            infoResidue0.booklist[n] = buffer.read(8);
            ++n;
        }
        if (infoResidue0.groupbook >= info.books) {
            this.free_info(infoResidue0);
            return null;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (infoResidue0.booklist[n4] >= info.books) {
                this.free_info(infoResidue0);
                return null;
            }
            ++n4;
        }
        return infoResidue0;
    }

    Object look(DspState dspState, InfoMode infoMode, Object object) {
        int n;
        int n2;
        InfoResidue0 infoResidue0 = (InfoResidue0)object;
        LookResidue0 lookResidue0 = new LookResidue0();
        int n3 = 0;
        int n4 = 0;
        lookResidue0.info = infoResidue0;
        lookResidue0.map = infoMode.mapping;
        lookResidue0.parts = infoResidue0.partitions;
        lookResidue0.fullbooks = dspState.fullbooks;
        lookResidue0.phrasebook = dspState.fullbooks[infoResidue0.groupbook];
        int n5 = lookResidue0.phrasebook.dim;
        lookResidue0.partbooks = new int[lookResidue0.parts][];
        int n6 = 0;
        while (n6 < lookResidue0.parts) {
            n2 = Residue0.ilog(infoResidue0.secondstages[n6]);
            if (n2 != 0) {
                if (n2 > n4) {
                    n4 = n2;
                }
                lookResidue0.partbooks[n6] = new int[n2];
                n = 0;
                while (n < n2) {
                    if ((infoResidue0.secondstages[n6] & 1 << n) != 0) {
                        lookResidue0.partbooks[n6][n] = infoResidue0.booklist[n3++];
                    }
                    ++n;
                }
            }
            ++n6;
        }
        lookResidue0.partvals = (int)Math.rint(Math.pow(lookResidue0.parts, n5));
        lookResidue0.stages = n4;
        lookResidue0.decodemap = new int[lookResidue0.partvals][];
        n2 = 0;
        while (n2 < lookResidue0.partvals) {
            n = n2;
            int n7 = lookResidue0.partvals / lookResidue0.parts;
            lookResidue0.decodemap[n2] = new int[n5];
            int n8 = 0;
            while (n8 < n5) {
                int n9 = n / n7;
                n -= n9 * n7;
                n7 /= lookResidue0.parts;
                lookResidue0.decodemap[n2][n8] = n9;
                ++n8;
            }
            ++n2;
        }
        return lookResidue0;
    }

    void free_info(Object object) {
    }

    void free_look(Object object) {
    }

    int forward(Block block, Object object, float[][] fArray, int n) {
        System.err.println("Residue0.forward: not implemented");
        return 0;
    }

    static synchronized int _01inverse(Block block, Object object, float[][] fArray, int n, int n2) {
        int n3;
        LookResidue0 lookResidue0 = (LookResidue0)object;
        InfoResidue0 infoResidue0 = lookResidue0.info;
        int n4 = infoResidue0.grouping;
        int n5 = lookResidue0.phrasebook.dim;
        int n6 = infoResidue0.end - infoResidue0.begin;
        int n7 = n6 / n4;
        int n8 = (n7 + n5 - 1) / n5;
        if (partword.length < n) {
            partword = new int[n][][];
            n3 = 0;
            while (n3 < n) {
                Residue0.partword[n3] = new int[n8][];
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n) {
                if (partword[n3] == null || partword[n3].length < n8) {
                    Residue0.partword[n3] = new int[n8][];
                }
                ++n3;
            }
        }
        int n9 = 0;
        while (n9 < lookResidue0.stages) {
            int n10 = 0;
            int n11 = 0;
            while (n10 < n7) {
                int n12;
                if (n9 == 0) {
                    n3 = 0;
                    while (n3 < n) {
                        n12 = lookResidue0.phrasebook.decode(block.opb);
                        if (n12 == -1) {
                            return 0;
                        }
                        Residue0.partword[n3][n11] = lookResidue0.decodemap[n12];
                        if (partword[n3][n11] == null) {
                            return 0;
                        }
                        ++n3;
                    }
                }
                int n13 = 0;
                while (n13 < n5 && n10 < n7) {
                    n3 = 0;
                    while (n3 < n) {
                        CodeBook codeBook;
                        n12 = infoResidue0.begin + n10 * n4;
                        if ((infoResidue0.secondstages[partword[n3][n11][n13]] & 1 << n9) != 0 && (codeBook = lookResidue0.fullbooks[lookResidue0.partbooks[partword[n3][n11][n13]][n9]]) != null && (n2 == 0 ? codeBook.decodevs_add(fArray[n3], n12, block.opb, n4) == -1 : n2 == 1 && codeBook.decodev_add(fArray[n3], n12, block.opb, n4) == -1)) {
                            return 0;
                        }
                        ++n3;
                    }
                    ++n13;
                    ++n10;
                }
                ++n11;
            }
            ++n9;
        }
        return 0;
    }

    static int _2inverse(Block block, Object object, float[][] fArray, int n) {
        LookResidue0 lookResidue0 = (LookResidue0)object;
        InfoResidue0 infoResidue0 = lookResidue0.info;
        int n2 = infoResidue0.grouping;
        int n3 = lookResidue0.phrasebook.dim;
        int n4 = infoResidue0.end - infoResidue0.begin;
        int n5 = n4 / n2;
        int n6 = (n5 + n3 - 1) / n3;
        int[][] nArrayArray = new int[n6][];
        int n7 = 0;
        while (n7 < lookResidue0.stages) {
            int n8 = 0;
            int n9 = 0;
            while (n8 < n5) {
                int n10;
                if (n7 == 0) {
                    n10 = lookResidue0.phrasebook.decode(block.opb);
                    if (n10 == -1) {
                        return 0;
                    }
                    nArrayArray[n9] = lookResidue0.decodemap[n10];
                    if (nArrayArray[n9] == null) {
                        return 0;
                    }
                }
                int n11 = 0;
                while (n11 < n3 && n8 < n5) {
                    CodeBook codeBook;
                    n10 = infoResidue0.begin + n8 * n2;
                    if ((infoResidue0.secondstages[nArrayArray[n9][n11]] & 1 << n7) != 0 && (codeBook = lookResidue0.fullbooks[lookResidue0.partbooks[nArrayArray[n9][n11]][n7]]) != null && codeBook.decodevv_add(fArray, n10, n, block.opb, n2) == -1) {
                        return 0;
                    }
                    ++n11;
                    ++n8;
                }
                ++n9;
            }
            ++n7;
        }
        return 0;
    }

    int inverse(Block block, Object object, float[][] fArray, int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (nArray[n3] != 0) {
                fArray[n2++] = fArray[n3];
            }
            ++n3;
        }
        if (n2 != 0) {
            return Residue0._01inverse(block, object, fArray, n2, 0);
        }
        return 0;
    }

    private static int ilog(int n) {
        int n2 = 0;
        while (n != 0) {
            ++n2;
            n >>>= 1;
        }
        return n2;
    }

    private static int icount(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += n & 1;
            n >>>= 1;
        }
        return n2;
    }
}

