/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.ExtendedClosedChannelException;
import org.xsocket.connection.IBlockingConnection;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IWriteCompletionHandler;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingConnection
implements IBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    public static final String READ_TIMEOUT_KEY = "org.xsocket.connection.readtimeoutMillis";
    public static final int DEFAULT_TIMEOUT = Integer.parseInt(System.getProperty("org.xsocket.connection.readtimeoutMillis", Integer.toString(Integer.MAX_VALUE)));
    private final ReadNotificationHandler handler = new ReadNotificationHandler();
    private final Object readGuard = new Object();
    private final INonBlockingConnection delegee;
    private int readTimeout = DEFAULT_TIMEOUT;
    private AtomicBoolean disconnected = new AtomicBoolean(false);
    private AtomicBoolean idleTimeout = new AtomicBoolean(false);
    private AtomicBoolean connectionTimeout = new AtomicBoolean(false);

    public BlockingConnection(String hostname, int port) throws IOException {
        this(new InetSocketAddress(hostname, port), null, true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(String hostname, int port, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(hostname, port), null, true, Integer.MAX_VALUE, options, null, false);
    }

    public BlockingConnection(InetAddress address, int port) throws IOException {
        this(address, port, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), null, true, connectTimeoutMillis, new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), null, true, Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), null, true, connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), null, true, Integer.MAX_VALUE, options, sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), null, true, connectTimeoutMillis, options, sslContext, sslOn);
    }

    public BlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), null, true, Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public BlockingConnection(InetSocketAddress remoteAddress, InetSocketAddress localAddress, boolean waitForConnect, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this.delegee = new NonBlockingConnection(remoteAddress, localAddress, (IHandler)this.handler, waitForConnect, connectTimeoutMillis, options, sslContext, sslOn);
    }

    public BlockingConnection(INonBlockingConnection delegee) throws IOException {
        this.delegee = delegee;
        delegee.setHandler(this.handler);
    }

    final INonBlockingConnection getDelegee() {
        return this.delegee;
    }

    @Override
    public void setReadTimeoutMillis(int timeout) throws IOException {
        this.readTimeout = timeout;
        int soTimeout = (Integer)this.delegee.getOption("SOL_SOCKET.SO_TIMEOUT");
        if (timeout > soTimeout) {
            this.delegee.setOption("SOL_SOCKET.SO_TIMEOUT", timeout);
        }
    }

    @Override
    public void setReceiveTimeoutMillis(int timeout) throws IOException {
        this.setReadTimeoutMillis(timeout);
    }

    @Override
    public final int getReceiveTimeoutMillis() throws IOException {
        return this.getReadTimeoutMillis();
    }

    @Override
    public int getReadTimeoutMillis() throws IOException {
        return this.readTimeout;
    }

    @Override
    public int getMaxReadBufferThreshold() {
        return this.delegee.getMaxReadBufferThreshold();
    }

    @Override
    public void setMaxReadBufferThreshold(int size) {
        this.delegee.setMaxReadBufferThreshold(size);
    }

    @Override
    public final void setEncoding(String defaultEncoding) {
        this.delegee.setEncoding(defaultEncoding);
    }

    @Override
    public final String getEncoding() {
        return this.delegee.getEncoding();
    }

    @Override
    public final boolean isOpen() {
        return this.delegee.isOpen();
    }

    @Override
    public boolean isServerSide() {
        return this.delegee.isServerSide();
    }

    @Override
    public final void close() throws IOException {
        this.delegee.close();
    }

    @Override
    public final void flush() throws ClosedChannelException, IOException, SocketTimeoutException {
        this.delegee.flush();
    }

    @Override
    public String getId() {
        return this.delegee.getId();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.delegee.getRemoteAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.delegee.getRemotePort();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.delegee.getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.delegee.getLocalPort();
    }

    @Override
    public final int getPendingWriteDataSize() {
        return this.delegee.getPendingWriteDataSize();
    }

    @Override
    public final void suspendRead() throws IOException {
        this.delegee.suspendReceiving();
    }

    @Override
    public boolean isReadSuspended() {
        return this.delegee.isReceivingSuspended();
    }

    @Override
    public final void resumeRead() throws IOException {
        this.delegee.resumeReceiving();
    }

    @Override
    public boolean isReceivingSuspended() {
        return this.delegee.isReceivingSuspended();
    }

    @Override
    public void resumeReceiving() throws IOException {
        this.delegee.resumeReceiving();
    }

    @Override
    public void suspendReceiving() throws IOException {
        this.delegee.suspendReceiving();
    }

    @Override
    public void setFlushmode(IConnection.FlushMode flushMode) {
        this.delegee.setFlushmode(flushMode);
    }

    @Override
    public IConnection.FlushMode getFlushmode() {
        return this.delegee.getFlushmode();
    }

    @Override
    public final void setOption(String name, Object value) throws IOException {
        this.delegee.setOption(name, value);
    }

    @Override
    public final Object getOption(String name) throws IOException {
        return this.delegee.getOption(name);
    }

    @Override
    public final Map<String, Class> getOptions() {
        return this.delegee.getOptions();
    }

    @Override
    public final void setIdleTimeoutMillis(long timeoutInMillis) {
        this.delegee.setIdleTimeoutMillis(timeoutInMillis);
    }

    @Override
    public final long getIdleTimeoutMillis() {
        return this.delegee.getIdleTimeoutMillis();
    }

    @Override
    public final void setConnectionTimeoutMillis(long timeoutMillis) {
        this.delegee.setConnectionTimeoutMillis(timeoutMillis);
    }

    @Override
    public final long getConnectionTimeoutMillis() {
        return this.delegee.getConnectionTimeoutMillis();
    }

    @Override
    public long getRemainingMillisToConnectionTimeout() {
        return this.delegee.getRemainingMillisToConnectionTimeout();
    }

    @Override
    public long getRemainingMillisToIdleTimeout() {
        return this.delegee.getRemainingMillisToIdleTimeout();
    }

    @Override
    public final void setAttachment(Object obj) {
        this.delegee.setAttachment(obj);
    }

    @Override
    public final Object getAttachment() {
        return this.delegee.getAttachment();
    }

    @Override
    public final void setAutoflush(boolean autoflush) {
        this.delegee.setAutoflush(autoflush);
    }

    @Override
    public final boolean isAutoflush() {
        return this.delegee.isAutoflush();
    }

    @Override
    public final void activateSecuredMode() throws IOException {
        this.delegee.activateSecuredMode();
    }

    @Override
    public boolean isSecure() {
        return this.delegee.isSecure();
    }

    @Override
    public final void markReadPosition() {
        this.delegee.markReadPosition();
    }

    @Override
    public final void markWritePosition() {
        this.delegee.markWritePosition();
    }

    @Override
    public void unread(ByteBuffer[] buffers) throws IOException {
        this.delegee.unread(buffers);
    }

    @Override
    public void unread(byte[] bytes) throws IOException {
        this.delegee.unread(bytes);
    }

    @Override
    public void unread(ByteBuffer buffer) throws IOException {
        this.delegee.unread(buffer);
    }

    @Override
    public void unread(String text) throws IOException {
        this.delegee.unread(text);
    }

    @Override
    public final int read(ByteBuffer buffer) throws IOException, ClosedChannelException {
        int size = buffer.remaining();
        if (size < 1) {
            return 0;
        }
        long remainingTime = this.readTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                int read;
                int availableSize;
                if ((availableSize = this.delegee.available()) > 0 && (read = this.delegee.read(buffer)) > 0) {
                    return read;
                }
                if (availableSize == -1) {
                    this.delegee.read(ByteBuffer.allocate(0));
                }
                if (!this.isOpen()) {
                    return -1;
                }
                remainingTime = this.waitForData(remainingTime);
            }
        }
    }

    private long waitForData(long remainingTime) throws ClosedChannelException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        if (this.isOpen()) {
            try {
                this.readGuard.wait(remainingTime);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            long elapsed = System.currentTimeMillis() - start;
            if ((remainingTime -= elapsed) > 0L) {
                return remainingTime;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "[ receive timeout " + DataConverter.toFormatedDuration(this.readTimeout) + " reached. throwing timeout exception");
            }
            String msg = "timeout " + DataConverter.toFormatedDuration(this.readTimeout) + " reached for " + this.getId();
            if (this.idleTimeout.get()) {
                msg = msg + " IDLE timeout";
            } else if (this.connectionTimeout.get()) {
                msg = msg + " CONNECTION timeout";
            } else if (this.disconnected.get()) {
                msg = msg + " DISCONNECTED by peer?";
            }
            if (this.delegee instanceof NonBlockingConnection) {
                NonBlockingConnection nbc = (NonBlockingConnection)this.delegee;
                msg = msg + " (read buffer size=" + this.getSize() + ", sendBytes=" + nbc.getNumberOfSendBytes() + ", receivedBytes=" + nbc.getNumberOfReceivedBytes() + ", pendingWriteDataSize=" + nbc.getPendingWriteDataSize() + ")";
            } else {
                msg = msg + " (read buffer size=" + this.getSize() + ")";
            }
            throw new SocketTimeoutException(msg);
        }
        throw new ExtendedClosedChannelException("channel " + this.getId() + " is closed (read buffer size=" + this.getSize() + ")");
    }

    private Integer getSize() {
        try {
            return this.delegee.available();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte readByte() throws IOException, SocketTimeoutException {
        long remainingTime = this.readTimeout;
        while (true) {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readByte();
                }
                catch (BufferUnderflowException bue) {
                    remainingTime = this.waitForData(remainingTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final short readShort() throws IOException, SocketTimeoutException {
        long remainingTime = this.readTimeout;
        while (true) {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readShort();
                }
                catch (BufferUnderflowException bue) {
                    remainingTime = this.waitForData(remainingTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int readInt() throws IOException, SocketTimeoutException {
        long remainingTime = this.readTimeout;
        while (true) {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readInt();
                }
                catch (BufferUnderflowException bue) {
                    remainingTime = this.waitForData(remainingTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long readLong() throws IOException, SocketTimeoutException {
        long remainingTime = this.readTimeout;
        while (true) {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readLong();
                }
                catch (BufferUnderflowException bue) {
                    remainingTime = this.waitForData(remainingTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double readDouble() throws IOException, SocketTimeoutException {
        long remainingTime = this.readTimeout;
        while (true) {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readDouble();
                }
                catch (BufferUnderflowException bue) {
                    remainingTime = this.waitForData(remainingTime);
                }
            }
        }
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, this.getEncoding());
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        long remainingTime = this.readTimeout;
        while (true) {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readByteBufferByDelimiter(delimiter, encoding, maxLength);
                }
                catch (MaxReadSizeExceededException mre) {
                    throw mre;
                }
                catch (BufferUnderflowException bue) {
                    remainingTime = this.waitForData(remainingTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ByteBuffer[] readByteBufferByLength(int length) throws IOException, SocketTimeoutException {
        if (length <= 0) {
            return new ByteBuffer[0];
        }
        long remainingTime = this.readTimeout;
        while (true) {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readByteBufferByLength(length);
                }
                catch (BufferUnderflowException bue) {
                    remainingTime = this.waitForData(remainingTime);
                }
            }
        }
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter) throws IOException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, this.getEncoding());
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, encoding, maxLength));
    }

    @Override
    public final byte[] readBytesByLength(int length) throws IOException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    @Override
    public final String readStringByDelimiter(String delimiter) throws IOException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public final String readStringByDelimiter(String delimiter, int maxLength) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    @Override
    public final String readStringByDelimiter(String delimiter, String encoding) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    @Override
    public final String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return DataConverter.toString(this.readByteBufferByDelimiter(delimiter, encoding, maxLength), encoding);
    }

    @Override
    public final String readStringByLength(int length) throws IOException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByLength(length, this.getEncoding());
    }

    @Override
    public final String readStringByLength(int length, String encoding) throws IOException, UnsupportedEncodingException, SocketTimeoutException {
        return DataConverter.toString(this.readByteBufferByLength(length), encoding);
    }

    @Override
    public final long transferTo(WritableByteChannel target, int length) throws IOException, SocketTimeoutException {
        ByteBuffer[] buffers;
        long written = 0L;
        for (ByteBuffer buffer : buffers = this.readByteBufferByLength(length)) {
            written += (long)target.write(buffer);
        }
        return written;
    }

    @Override
    public final boolean resetToWriteMark() {
        return this.delegee.resetToWriteMark();
    }

    @Override
    public final boolean resetToReadMark() {
        return this.delegee.resetToReadMark();
    }

    @Override
    public final void removeReadMark() {
        this.delegee.removeReadMark();
    }

    @Override
    public final void removeWriteMark() {
        this.delegee.removeWriteMark();
    }

    @Override
    public final int write(byte b) throws IOException, BufferOverflowException {
        return this.delegee.write(b);
    }

    @Override
    public final int write(byte ... bytes) throws IOException {
        return this.delegee.write(bytes);
    }

    @Override
    public void write(byte[] bytes, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegee.write(bytes, writeCompletionHandler);
    }

    @Override
    public final int write(byte[] bytes, int offset, int length) throws IOException {
        return this.delegee.write(bytes, offset, length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegee.write(bytes, offset, length, writeCompletionHandler);
    }

    @Override
    public final int write(short s) throws IOException {
        return this.delegee.write(s);
    }

    @Override
    public final int write(int i) throws IOException {
        return this.delegee.write(i);
    }

    @Override
    public final int write(long l) throws IOException {
        return this.delegee.write(l);
    }

    @Override
    public final int write(double d) throws IOException {
        return this.delegee.write(d);
    }

    @Override
    public final int write(String message) throws IOException {
        return this.delegee.write(message);
    }

    @Override
    public final int write(String message, String encoding) throws IOException {
        return this.delegee.write(message, encoding);
    }

    @Override
    public void write(String message, String encoding, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegee.write(message, encoding, writeCompletionHandler);
    }

    public final long write(ArrayList<ByteBuffer> buffers) throws IOException {
        return this.delegee.write(buffers);
    }

    @Override
    public final long write(List<ByteBuffer> buffers) throws IOException {
        return this.delegee.write(buffers);
    }

    @Override
    public final long write(ByteBuffer[] buffers) throws IOException {
        return this.delegee.write(buffers);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegee.write(srcs, offset, length);
    }

    @Override
    public final int write(ByteBuffer buffer) throws IOException {
        return this.delegee.write(buffer);
    }

    @Override
    public void write(ByteBuffer buffer, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegee.write(buffer, writeCompletionHandler);
    }

    @Override
    public void write(ByteBuffer[] buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegee.write(buffers, writeCompletionHandler);
    }

    @Override
    public void write(ByteBuffer[] srcs, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegee.write(srcs, offset, length, writeCompletionHandler);
    }

    @Override
    public final long transferFrom(ReadableByteChannel source) throws IOException {
        return this.delegee.transferFrom(source);
    }

    @Override
    public void write(List<ByteBuffer> buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegee.write(buffers, writeCompletionHandler);
    }

    @Override
    public final long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException {
        return this.delegee.transferFrom(source, chunkSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReadDataInserted() {
        Object object = this.readGuard;
        synchronized (object) {
            this.readGuard.notifyAll();
        }
    }

    @Override
    public long transferFrom(FileChannel source) throws IOException {
        return this.delegee.transferFrom(source);
    }

    public String toString() {
        return this.delegee.toString();
    }

    final class ReadNotificationHandler
    implements IDataHandler,
    IDisconnectHandler,
    IConnectionTimeoutHandler,
    IIdleTimeoutHandler {
        ReadNotificationHandler() {
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            BlockingConnection.this.onReadDataInserted();
            return true;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            BlockingConnection.this.disconnected.set(true);
            BlockingConnection.this.onReadDataInserted();
            return true;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            BlockingConnection.this.connectionTimeout.set(true);
            BlockingConnection.this.onReadDataInserted();
            connection.close();
            return true;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            BlockingConnection.this.idleTimeout.set(true);
            BlockingConnection.this.onReadDataInserted();
            connection.close();
            return true;
        }
    }
}

