/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONWriter {
    private boolean comma = false;
    protected char mode = (char)105;
    private final JSONObject[] stack = new JSONObject[200];
    private int top = 0;
    protected Writer writer;

    /*
     * WARNING - void declaration
     */
    public JSONWriter(Writer w) {
        void var1_1;
        this.writer = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private JSONWriter append(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.write(44);
                }
                this.writer.write(string);
            }
            catch (IOException e) {
                void var1_2;
                throw new JSONException((Throwable)var1_2);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    public JSONWriter array() throws JSONException {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push(null);
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    /*
     * WARNING - void declaration
     */
    private JSONWriter end(char mode2, char c) throws JSONException {
        if (this.mode != mode2) {
            throw new JSONException(mode2 == 'a' ? "Misplaced endArray." : "Misplaced endObject.");
        }
        char c2 = mode2;
        JSONWriter mode2 = this;
        if (mode2.top <= 0) {
            throw new JSONException("Nesting error.");
        }
        char c3 = mode2.stack[mode2.top - 1] == null ? (char)'a' : 'k';
        if (c3 != c2) {
            throw new JSONException("Nesting error.");
        }
        --mode2.top;
        mode2.mode = (char)(mode2.top == 0 ? 100 : (mode2.stack[mode2.top - 1] == null ? 97 : 107));
        try {
            void var2_4;
            this.writer.write((int)var2_4);
        }
        catch (IOException e) {
            void var1_3;
            throw new JSONException((Throwable)var1_3);
        }
        this.comma = true;
        return this;
    }

    public JSONWriter endArray() throws JSONException {
        return this.end('a', ']');
    }

    public JSONWriter endObject() throws JSONException {
        return this.end('k', '}');
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter key(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                this.stack[this.top - 1].putOnce(string, Boolean.TRUE);
                if (this.comma) {
                    this.writer.write(44);
                }
                this.writer.write(JSONObject.quote(string));
                this.writer.write(58);
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException e) {
                void var1_2;
                throw new JSONException((Throwable)var1_2);
            }
        }
        throw new JSONException("Misplaced key.");
    }

    public JSONWriter object() throws JSONException {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push(new JSONObject());
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    /*
     * WARNING - void declaration
     */
    private void push(JSONObject jo) throws JSONException {
        void var1_1;
        if (this.top >= 200) {
            throw new JSONException("Nesting too deep.");
        }
        this.stack[this.top] = jo;
        this.mode = (char)(var1_1 == null ? 97 : 107);
        ++this.top;
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter value(boolean b) throws JSONException {
        void var1_1;
        return this.append(var1_1 != false ? "true" : "false");
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter value(double d) throws JSONException {
        void var1_1;
        return this.value(new Double((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter value(long l) throws JSONException {
        void var1_1;
        return this.append(Long.toString((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public JSONWriter value(Object object) throws JSONException {
        void var1_1;
        return this.append(JSONObject.valueToString(var1_1));
    }
}

