/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONString;
import org.json.JSONTokener;

public class JSONObject {
    private Map map = new HashMap();
    public static final Object NULL = new Null();

    public JSONObject() {
    }

    public JSONObject(JSONObject jo, String[] names) {
        this();
        for (int i = 0; i < names.length; ++i) {
            try {
                this.putOnce(names[i], jo.opt(names[i]));
                continue;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(JSONTokener x) throws JSONException {
        this();
        void var1_1;
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            void var3_3;
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            char c2 = x.nextClean();
            if (c2 == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce((String)var3_3, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw var1_1.syntaxError("Expected a ',' or '}'");
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(Map map) {
        if (map != null) {
            for (Map.Entry e : map.entrySet()) {
                void var3_3;
                void var2_2;
                Object value = e.getValue();
                if (value == null) continue;
                this.map.put(var2_2.getKey(), JSONObject.wrap(var3_3));
            }
        }
    }

    public JSONObject(Object bean) {
        this();
        JSONObject jSONObject;
        void var2_2 = jSONObject;
        jSONObject = this;
        Method[] methodArray = var2_2.getClass();
        int n = methodArray.getClassLoader() != null ? 1 : 0;
        methodArray = n != 0 ? methodArray.getMethods() : methodArray.getDeclaredMethods();
        for (n = 0; n < methodArray.length; ++n) {
            try {
                Object object = methodArray[n];
                if (!Modifier.isPublic(((Method)object).getModifiers())) continue;
                String string = ((Method)object).getName();
                String string2 = "";
                if (string.startsWith("get")) {
                    string2 = string.equals("getClass") || string.equals("getDeclaringClass") ? "" : string.substring(3);
                } else if (string.startsWith("is")) {
                    string2 = string.substring(2);
                }
                if (string2.length() <= 0 || !Character.isUpperCase(string2.charAt(0)) || ((Method)object).getParameterTypes().length != 0) continue;
                if (string2.length() == 1) {
                    string2 = string2.toLowerCase();
                } else if (!Character.isUpperCase(string2.charAt(1))) {
                    string2 = string2.substring(0, 1).toLowerCase() + string2.substring(1);
                }
                object = ((Method)object).invoke((Object)var2_2, null);
                if (object == null) continue;
                jSONObject.map.put(string2, JSONObject.wrap(object));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(Object object, String[] names) {
        this();
        Class<?> c = object.getClass();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                this.putOpt(name, c.getField(name).get(object));
                continue;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(String source) throws JSONException {
        this(new JSONTokener((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject(String baseName, Locale locale) throws JSONException {
        this();
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale, Thread.currentThread().getContextClassLoader());
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            void var3_3;
            String key = keys.nextElement();
            if (!(key instanceof String)) continue;
            String[] path = key.split("\\.");
            int last = path.length - 1;
            JSONObject target = this;
            for (int i = 0; i < last; ++i) {
                String segment = path[i];
                JSONObject nextTarget = target.optJSONObject(segment);
                if (nextTarget == null) {
                    nextTarget = new JSONObject();
                    target.put(segment, nextTarget);
                }
                target = nextTarget;
            }
            target.put(path[last], bundle.getString((String)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject accumulate(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object object = this.opt(key);
        if (object == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).put(value);
        } else {
            void var2_2;
            void var3_3;
            void var1_1;
            this.put((String)var1_1, new JSONArray().put(var3_3).put(var2_2));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject append(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object object = this.opt(key);
        if (object == null) {
            this.put(key, new JSONArray().put(value));
        } else if (object instanceof JSONArray) {
            void var2_2;
            void var3_3;
            this.put(key, ((JSONArray)var3_3).put(var2_2));
        } else {
            void var1_1;
            throw new JSONException("JSONObject[" + (String)var1_1 + "] is not a JSONArray.");
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public static String doubleToString(double d) {
        void var0_1;
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public Object get(String key) throws JSONException {
        void var2_2;
        if (key == null) {
            throw new JSONException("Null key.");
        }
        Object object = this.opt(key);
        if (object == null) {
            void var1_1;
            throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] not found.");
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(String key) throws JSONException {
        void var1_1;
        void var2_2;
        Object object = this.get(key);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)var2_2).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] is not a Boolean.");
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(String key) throws JSONException {
        Object object = this.get(key);
        try {
            void var2_2;
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return Double.parseDouble((String)var2_2);
        }
        catch (Exception exception) {
            void var1_1;
            throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] is not a number.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(String key) throws JSONException {
        Object object = this.get(key);
        try {
            void var2_2;
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return Integer.parseInt((String)var2_2);
        }
        catch (Exception exception) {
            void var1_1;
            throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] is not an int.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray getJSONArray(String key) throws JSONException {
        void var1_1;
        Object object = this.get(key);
        if (object instanceof JSONArray) {
            void var2_2;
            return (JSONArray)var2_2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] is not a JSONArray.");
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject getJSONObject(String key) throws JSONException {
        void var1_1;
        Object object = this.get(key);
        if (object instanceof JSONObject) {
            void var2_2;
            return (JSONObject)var2_2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] is not a JSONObject.");
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(String key) throws JSONException {
        Object object = this.get(key);
        try {
            void var2_2;
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            return Long.parseLong((String)var2_2);
        }
        catch (Exception exception) {
            void var1_1;
            throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] is not a long.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getNames(JSONObject jo) {
        void var1_2;
        int length = jo.length();
        if (length == 0) {
            return null;
        }
        Iterator iterator = jo.keys();
        String[] names = new String[length];
        int i = 0;
        while (iterator.hasNext()) {
            names[i] = (String)iterator.next();
            ++i;
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] getNames(Object object) {
        void var2_2;
        if (object == null) {
            return null;
        }
        Field[] fields = (object = object.getClass()).getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = fields[i].getName();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String getString(String key) throws JSONException {
        void var1_1;
        Object object = this.get(key);
        if (object instanceof String) {
            void var2_2;
            return (String)var2_2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote((String)var1_1) + "] not a string.");
    }

    /*
     * WARNING - void declaration
     */
    public boolean has(String key) {
        void var1_1;
        return this.map.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject increment(String key) throws JSONException {
        Object value = this.opt(key);
        if (value == null) {
            this.put(key, 1);
        } else if (value instanceof Integer) {
            this.put(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.put(key, (Long)value + 1L);
        } else if (value instanceof Double) {
            this.put(key, (Double)value + 1.0);
        } else if (value instanceof Float) {
            void var2_2;
            this.put(key, ((Float)var2_2).floatValue() + 1.0f);
        } else {
            void var1_1;
            throw new JSONException("Unable to increment [" + JSONObject.quote((String)var1_1) + "].");
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNull(String key) {
        void var1_1;
        return NULL.equals(this.opt((String)var1_1));
    }

    public Iterator keys() {
        return this.map.keySet().iterator();
    }

    public int length() {
        return this.map.size();
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray names() {
        void var1_1;
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        if (ja.length() == 0) {
            return null;
        }
        return var1_1;
    }

    public static String numberToString(Number number) throws JSONException {
        Object object;
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number);
        Object string = number.toString();
        if (((String)string).indexOf(46) > 0 && ((String)string).indexOf(101) < 0 && ((String)string).indexOf(69) < 0) {
            while (((String)string).endsWith("0")) {
                string = ((String)string).substring(0, ((String)string).length() - 1);
            }
            if (((String)string).endsWith(".")) {
                string = ((String)string).substring(0, ((String)string).length() - 1);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Object opt(String key) {
        void var1_1;
        if (key == null) {
            return null;
        }
        return this.map.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(String key) {
        void var1_1;
        return this.optBoolean((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            void var1_1;
            return this.getBoolean((String)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return (boolean)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(String key) {
        void var1_1;
        return this.optDouble((String)var1_1, Double.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(String key, double defaultValue) {
        try {
            void var1_1;
            return this.getDouble((String)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return (double)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(String key) {
        void var1_1;
        return this.optInt((String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(String key, int defaultValue) {
        try {
            void var1_1;
            return this.getInt((String)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return (int)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        if (o instanceof JSONArray) {
            void var1_1;
            return (JSONArray)var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject optJSONObject(String key) {
        Object object = this.opt(key);
        if (object instanceof JSONObject) {
            void var1_1;
            return (JSONObject)var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(String key) {
        void var1_1;
        return this.optLong((String)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(String key, long defaultValue) {
        try {
            void var1_1;
            return this.getLong((String)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return (long)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String optString(String key) {
        void var1_1;
        return this.optString((String)var1_1, "");
    }

    /*
     * WARNING - void declaration
     */
    public String optString(String key, String defaultValue) {
        void var1_1;
        Object object = this.opt(key);
        if (NULL.equals(object)) {
            void var2_2;
            return var2_2;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, boolean value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((String)var1_1, var2_2 != false ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, Collection value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((String)var1_1, new JSONArray((Collection)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, double value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((String)var1_1, new Double((double)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, int value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((String)var1_1, new Integer((int)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, long value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((String)var1_1, new Long((long)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, Map value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((String)var1_1, new JSONObject((Map)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            void var2_2;
            JSONObject.testValidity(value);
            this.map.put(key, var2_2);
        } else {
            void var1_1;
            this.remove((String)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            void var2_2;
            void var1_1;
            if (this.opt(key) != null) {
                throw new JSONException("Duplicate key \"" + key + "\"");
            }
            this.put((String)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            void var2_2;
            void var1_1;
            this.put((String)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        void var1_6;
                        String hhhh = "000" + Integer.toHexString(c);
                        sb.append("\\u" + hhhh.substring(var1_6.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Object remove(String key) {
        void var1_1;
        return this.map.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object stringToValue(String string) {
        String string2;
        block13: {
            if (string.equals("")) {
                return string;
            }
            if (string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if (string.equalsIgnoreCase("null")) {
                return NULL;
            }
            char b = string.charAt(0);
            if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
                if (b == '0' && string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(string.substring(2), 16));
                    }
                    catch (Exception exception) {}
                }
                try {
                    void var1_3;
                    if (string.indexOf(46) >= 0 || string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                        Double d = Double.valueOf(string);
                        if (!d.isInfinite() && !d.isNaN()) {
                            return d;
                        }
                        break block13;
                    }
                    Long myLong = new Long(string);
                    if (myLong == (long)myLong.intValue()) {
                        return new Integer(myLong.intValue());
                    }
                    return var1_3;
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    public static void testValidity(Object o) throws JSONException {
        Object object;
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)object).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        void var2_2;
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        try {
            void var2_2;
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                void var3_3;
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JSONObject.quote(o.toString()));
                sb.append(':');
                sb.append(JSONObject.valueToString(this.map.get(var3_3)));
            }
            sb.append('}');
            return var2_2.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString(int indentFactor) throws JSONException {
        void var1_1;
        return this.toString((int)var1_1, 0);
    }

    private String toString(int indentFactor, int indent) throws JSONException {
        int length = this.length();
        if (length == 0) {
            return "{}";
        }
        Iterator keys = this.keys();
        int newindent = indent + indentFactor;
        StringBuffer sb = new StringBuffer("{");
        if (length == 1) {
            Object object = keys.next();
            sb.append(JSONObject.quote(object.toString()));
            sb.append(": ");
            sb.append(JSONObject.valueToString(this.map.get(object), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                Object object = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONObject.quote(object.toString()));
                sb.append(": ");
                sb.append(JSONObject.valueToString(this.map.get(object), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String valueToString(Object value) throws JSONException {
        Object object;
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof JSONString) {
            try {
                Object object2 = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                void var0_1;
                throw new JSONException((Throwable)var0_1);
            }
            if (object instanceof String) {
                return (String)object;
            }
            throw new JSONException("Bad value from toJSONString: " + object);
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean || object instanceof JSONObject || object instanceof JSONArray) {
            return object.toString();
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object).toString();
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString();
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString();
        }
        return JSONObject.quote(object.toString());
    }

    /*
     * WARNING - void declaration
     */
    static String valueToString(Object value, int indentFactor, int indent) throws JSONException {
        Object object;
        if (value == null || value.equals(null)) {
            return "null";
        }
        try {
            String o;
            if (value instanceof JSONString && (o = ((JSONString)value).toJSONString()) instanceof String) {
                void var3_3;
                return (String)var3_3;
            }
        }
        catch (Exception exception) {}
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString(indentFactor, indent);
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString(indentFactor, indent);
        }
        if (value.getClass().isArray()) {
            void var2_2;
            void var1_1;
            return new JSONArray(value).toString((int)var1_1, (int)var2_2);
        }
        return JSONObject.quote(object.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static Object wrap(Object object) {
        try {
            Object object2;
            void var1_1;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            Package objectPackage = object.getClass().getPackage();
            String objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || var1_1.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Writer write(Writer writer) throws JSONException {
        try {
            void var1_1;
            boolean commanate = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (commanate) {
                    writer.write(44);
                }
                Object key = keys.next();
                writer.write(JSONObject.quote(key.toString()));
                writer.write(58);
                Object value22 = this.map.get(key);
                if (value22 instanceof JSONObject) {
                    ((JSONObject)value22).write(writer);
                } else if (value22 instanceof JSONArray) {
                    ((JSONArray)value22).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(value22));
                }
                boolean value22 = true;
            }
            writer.write(125);
            return var1_1;
        }
        catch (IOException exception) {
            void var2_4;
            throw new JSONException((Throwable)var2_4);
        }
    }

    private static final class Null {
        private Null(byte by) {
        }

        protected final Object clone() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object object) {
            void var1_1;
            return object == null || var1_1 == this;
        }

        public final String toString() {
            return "null";
        }

        /* synthetic */ Null() {
            this(0);
        }
    }
}

