/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONArray {
    private ArrayList myArrayList = new ArrayList();

    public JSONArray() {
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() != ']') {
            void var1_1;
            x.back();
            block4: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                    this.myArrayList.add(JSONObject.NULL);
                } else {
                    x.back();
                    this.myArrayList.add(x.nextValue());
                }
                switch (x.nextClean()) {
                    case ',': 
                    case ';': {
                        if (x.nextClean() == ']') {
                            return;
                        }
                        x.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw var1_1.syntaxError("Expected a ',' or ']'");
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray(String source) throws JSONException {
        this(new JSONTokener((String)var1_1));
        void var1_1;
    }

    public JSONArray(Collection collection) {
        if (collection != null) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                this.myArrayList.add(JSONObject.wrap(iter.next()));
            }
        }
    }

    public JSONArray(Object array) throws JSONException {
        this();
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                this.put(JSONObject.wrap(Array.get(array, i)));
            }
            return;
        }
        throw new JSONException("JSONArray initial value should be a string or collection or array.");
    }

    /*
     * WARNING - void declaration
     */
    public Object get(int index) throws JSONException {
        void var2_2;
        Object object = this.opt(index);
        if (object == null) {
            void var1_1;
            throw new JSONException("JSONArray[" + (int)var1_1 + "] not found.");
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(int index) throws JSONException {
        void var1_1;
        void var2_2;
        Object object = this.get(index);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)var2_2).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + (int)var1_1 + "] is not a boolean.");
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(int index) throws JSONException {
        Object object = this.get(index);
        try {
            void var2_2;
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return Double.parseDouble((String)var2_2);
        }
        catch (Exception exception) {
            void var1_1;
            throw new JSONException("JSONArray[" + (int)var1_1 + "] is not a number.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(int index) throws JSONException {
        Object object = this.get(index);
        try {
            void var2_2;
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return Integer.parseInt((String)var2_2);
        }
        catch (Exception exception) {
            void var1_1;
            throw new JSONException("JSONArray[" + (int)var1_1 + "] is not a number.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray getJSONArray(int index) throws JSONException {
        void var1_1;
        Object object = this.get(index);
        if (object instanceof JSONArray) {
            void var2_2;
            return (JSONArray)var2_2;
        }
        throw new JSONException("JSONArray[" + (int)var1_1 + "] is not a JSONArray.");
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject getJSONObject(int index) throws JSONException {
        void var1_1;
        Object object = this.get(index);
        if (object instanceof JSONObject) {
            void var2_2;
            return (JSONObject)var2_2;
        }
        throw new JSONException("JSONArray[" + (int)var1_1 + "] is not a JSONObject.");
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(int index) throws JSONException {
        Object object = this.get(index);
        try {
            void var2_2;
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            return Long.parseLong((String)var2_2);
        }
        catch (Exception exception) {
            void var1_1;
            throw new JSONException("JSONArray[" + (int)var1_1 + "] is not a number.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getString(int index) throws JSONException {
        void var1_1;
        Object object = this.get(index);
        if (object instanceof String) {
            void var2_2;
            return (String)var2_2;
        }
        throw new JSONException("JSONArray[" + (int)var1_1 + "] not a string.");
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNull(int index) {
        void var1_1;
        return JSONObject.NULL.equals(this.opt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String join(String separator) throws JSONException {
        void var3_3;
        int len = this.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(JSONObject.valueToString(this.myArrayList.get(i)));
        }
        return var3_3.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    /*
     * WARNING - void declaration
     */
    public Object opt(int index) {
        void var1_1;
        if (index < 0 || index >= this.length()) {
            return null;
        }
        return this.myArrayList.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(int index) {
        void var1_1;
        return this.optBoolean((int)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            void var1_1;
            return this.getBoolean((int)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return (boolean)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(int index) {
        void var1_1;
        return this.optDouble((int)var1_1, Double.NaN);
    }

    /*
     * WARNING - void declaration
     */
    public double optDouble(int index, double defaultValue) {
        try {
            void var1_1;
            return this.getDouble((int)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return (double)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(int index) {
        void var1_1;
        return this.optInt((int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int optInt(int index, int defaultValue) {
        try {
            void var1_1;
            return this.getInt((int)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return (int)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray optJSONArray(int index) {
        Object o = this.opt(index);
        if (o instanceof JSONArray) {
            void var1_2;
            return (JSONArray)var1_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject optJSONObject(int index) {
        Object o = this.opt(index);
        if (o instanceof JSONObject) {
            void var1_2;
            return (JSONObject)var1_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(int index) {
        void var1_1;
        return this.optLong((int)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public long optLong(int index, long defaultValue) {
        try {
            void var1_1;
            return this.getLong((int)var1_1);
        }
        catch (Exception exception) {
            void var2_2;
            return (long)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String optString(int index) {
        void var1_1;
        return this.optString((int)var1_1, "");
    }

    /*
     * WARNING - void declaration
     */
    public String optString(int index, String defaultValue) {
        void var2_3;
        Object object = this.opt(index);
        if (JSONObject.NULL.equals(object)) {
            void var1_2;
            return var1_2.toString();
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(boolean value) {
        void var1_1;
        this.put(var1_1 != false ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(Collection value) {
        void var1_1;
        this.put(new JSONArray((Collection)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(double value) throws JSONException {
        void var1_2;
        Double d = new Double(value);
        JSONObject.testValidity(d);
        this.put(var1_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int value) {
        void var1_1;
        this.put(new Integer((int)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(long value) {
        void var1_1;
        this.put(new Long((long)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(Map value) {
        void var1_1;
        this.put(new JSONObject((Map)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(Object value) {
        void var1_1;
        this.myArrayList.add(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, boolean value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((int)var1_1, var2_2 != false ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, Collection value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((int)var1_1, new JSONArray((Collection)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, double value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((int)var1_1, new Double((double)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, int value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((int)var1_1, new Integer((int)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, long value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((int)var1_1, new Long((long)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, Map value) throws JSONException {
        void var2_2;
        void var1_1;
        this.put((int)var1_1, new JSONObject((Map)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray put(int index, Object value) throws JSONException {
        JSONObject.testValidity(value);
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            this.myArrayList.set(index, value);
        } else {
            void var2_2;
            while (index != this.length()) {
                this.put(JSONObject.NULL);
            }
            this.put(var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Object remove(int index) {
        void var2_2;
        void var1_1;
        Object o = this.opt(index);
        this.myArrayList.remove((int)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        void var2_2;
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i = 0; i < names.length(); ++i) {
            jo.put(names.getString(i), this.opt(i));
        }
        return var2_2;
    }

    public final String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString(int indentFactor) throws JSONException {
        void var1_1;
        return this.toString((int)var1_1, 0);
    }

    final String toString(int indentFactor, int indent) throws JSONException {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[");
        if (len == 1) {
            sb.append(JSONObject.valueToString(this.myArrayList.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JSONObject.valueToString(this.myArrayList.get(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Writer write(Writer writer) throws JSONException {
        try {
            void var1_1;
            boolean b = false;
            int len = this.length();
            writer.write(91);
            for (int i = 0; i < len; ++i) {
                Object v22;
                if (b) {
                    writer.write(44);
                }
                if ((v22 = this.myArrayList.get(i)) instanceof JSONObject) {
                    ((JSONObject)v22).write(writer);
                } else if (v22 instanceof JSONArray) {
                    ((JSONArray)v22).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v22));
                }
                boolean v22 = true;
            }
            writer.write(93);
            return var1_1;
        }
        catch (IOException e) {
            void var2_4;
            throw new JSONException((Throwable)var2_4);
        }
    }
}

